/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.rules;

import org.jgroups.View;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.rules.Rule;

public class CheckFDMonitor
extends Rule {
    protected FD fd;

    @Override
    public String name() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String description() {
        return "Starts FD.Monitor if membership > 1 and monitor isn't running";
    }

    @Override
    public void init() {
        super.init();
        this.fd = (FD)this.sv.getProtocolStack().findProtocol((Class<?>)FD.class);
        if (this.fd == null) {
            this.log.info("FD was not found, uninstalling myself (" + this.getClass().getSimpleName() + ")");
            this.sv.uninstallRule(this.getClass().getSimpleName());
        }
    }

    @Override
    public boolean eval() {
        return this.sv.getView() != null && this.sv.getView().size() > 1 && !this.fd.isMonitorRunning();
    }

    @Override
    public String condition() {
        View view = this.sv.getView();
        return "Membership is " + (view != null ? Integer.valueOf(view.size()) : "n/a") + ", FD.Monitor running=" + this.fd.isMonitorRunning();
    }

    @Override
    public void trigger() throws Throwable {
        System.out.println(this.sv.getLocalAddress() + ": starting failure detection");
        this.fd.startFailureDetection();
    }

    public String toString() {
        return CheckFDMonitor.class.getSimpleName() + ": " + this.condition();
    }
}

