/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.interceptors;

import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EntityEJBMetaData;
import org.jboss.ejb.client.StatefulEJBMetaData;
import org.jboss.ejb.client.StatelessEJBMetaData;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.msc.value.InjectedValue;

public class EjbMetadataInterceptor
implements Interceptor {
    private final InjectedValue<ComponentView> homeView = new InjectedValue();
    private final Class<?> remoteClass;
    private final Class<? extends EJBHome> homeClass;
    private final Class<?> pkClass;
    private final boolean session;
    private final boolean stateless;

    public EjbMetadataInterceptor(Class<?> remoteClass, Class<? extends EJBHome> homeClass, Class<?> pkClass, boolean session, boolean stateless) {
        this.remoteClass = remoteClass;
        this.homeClass = homeClass;
        this.pkClass = pkClass;
        this.session = session;
        this.stateless = stateless;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        EJBHome home = (EJBHome)((ComponentView)this.homeView.getValue()).createInstance().getInstance();
        if (this.session) {
            if (this.stateless) {
                return EjbMetadataInterceptor.createStatelessMetaData(this.remoteClass.asSubclass(EJBObject.class), this.homeClass, home);
            }
            return EjbMetadataInterceptor.createStatefulMetaData(this.remoteClass.asSubclass(EJBObject.class), this.homeClass, home);
        }
        return EjbMetadataInterceptor.createEntityMetaData(this.remoteClass.asSubclass(EJBObject.class), this.homeClass, home, this.pkClass);
    }

    private static <T extends EJBObject, H extends EJBHome> StatelessEJBMetaData<T, ? extends H> createStatelessMetaData(Class<T> remoteClass, Class<H> homeClass, EJBHome home) {
        return new StatelessEJBMetaData(remoteClass, EJBClient.getLocatorFor((Object)home).narrowAsHome(homeClass));
    }

    private static <T extends EJBObject, H extends EJBHome> StatefulEJBMetaData<T, ? extends H> createStatefulMetaData(Class<T> remoteClass, Class<H> homeClass, EJBHome home) {
        return new StatefulEJBMetaData(remoteClass, EJBClient.getLocatorFor((Object)home).narrowAsHome(homeClass));
    }

    private static <T extends EJBObject, H extends EJBHome> EntityEJBMetaData<T, ? extends H> createEntityMetaData(Class<T> remoteClass, Class<H> homeClass, EJBHome home, Class<?> pkClass) {
        return new EntityEJBMetaData(remoteClass, EJBClient.getLocatorFor((Object)home).narrowAsHome(homeClass), pkClass);
    }

    public InjectedValue<ComponentView> getHomeView() {
        return this.homeView;
    }
}

