/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformation;
import org.jboss.as.ejb3.cache.CacheInfo;
import org.jboss.as.ejb3.cache.EJBBoundCacheMetaData;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.processors.merging.AbstractMergingProcessor;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.ejb3.annotation.Cache;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class CacheMergingProcessor
extends AbstractMergingProcessor<StatefulComponentDescription> {
    public CacheMergingProcessor() {
        super(StatefulComponentDescription.class);
    }

    @Override
    protected void handleAnnotations(DeploymentUnit deploymentUnit, EEApplicationClasses applicationClasses, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription componentConfiguration) throws DeploymentUnitProcessingException {
        EEModuleClassDescription clazz = applicationClasses.getClassByName(componentClass.getName());
        if (clazz == null) {
            return;
        }
        ClassAnnotationInformation cache = clazz.getAnnotationInformation(Cache.class);
        if (cache == null) {
            return;
        }
        if (!cache.getClassLevelAnnotations().isEmpty()) {
            componentConfiguration.setCache((CacheInfo)cache.getClassLevelAnnotations().get(0));
        }
    }

    @Override
    protected void handleDeploymentDescriptor(DeploymentUnit deploymentUnit, DeploymentReflectionIndex deploymentReflectionIndex, Class<?> componentClass, StatefulComponentDescription description) throws DeploymentUnitProcessingException {
        String ejbName = description.getEJBName();
        EjbJarMetaData metaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (metaData == null) {
            return;
        }
        AssemblyDescriptorMetaData assemblyDescriptor = metaData.getAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            return;
        }
        List caches = assemblyDescriptor.getAny(EJBBoundCacheMetaData.class);
        String cacheName = null;
        if (caches != null) {
            for (EJBBoundCacheMetaData cacheMetaData : caches) {
                if ("*".equals(cacheMetaData.getEjbName()) && cacheName == null) {
                    cacheName = cacheMetaData.getCacheName();
                    continue;
                }
                if (!ejbName.equals(cacheMetaData.getEjbName())) continue;
                cacheName = cacheMetaData.getCacheName();
            }
        }
        if (cacheName != null) {
            description.setCache(new CacheInfo(cacheName));
        }
    }
}

