/*
 * Decompiled with CFR 0.152.
 */
package javax.websocket;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import javax.websocket.WebSocketContainer;

public abstract class ContainerProvider {
    public static WebSocketContainer getWebSocketContainer() {
        if (System.getSecurityManager() == null) {
            return ContainerProvider.getWebSocketContainerImpl();
        }
        return AccessController.doPrivileged(new PrivilegedAction<WebSocketContainer>(){

            @Override
            public WebSocketContainer run() {
                return ContainerProvider.getWebSocketContainerImpl();
            }
        });
    }

    private static WebSocketContainer getWebSocketContainerImpl() {
        WebSocketContainer wsc = null;
        for (ContainerProvider impl : ServiceLoader.load(ContainerProvider.class)) {
            wsc = impl.getContainer();
            if (wsc == null) continue;
            return wsc;
        }
        if (wsc == null) {
            throw new RuntimeException("Could not find an implementation class.");
        }
        throw new RuntimeException("Could not find an implementation class with a non-null WebSocketContainer.");
    }

    protected abstract WebSocketContainer getContainer();
}

