/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorServiceParamDefinition;
import org.jboss.as.messaging.DivertDefinition;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.GroupingHandlerDefinition;
import org.jboss.as.messaging.InVMTransportDefinition;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.PathDefinition;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.RemoteTransportDefinition;
import org.jboss.as.messaging.SecurityRoleDefinition;
import org.jboss.as.messaging.TransportParamDefinition;
import org.jboss.as.messaging.jms.ConnectionFactoryAttributes;
import org.jboss.as.messaging.logging.MessagingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class MessagingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    private static final EnumSet<Element> SIMPLE_ROOT_RESOURCE_ELEMENTS = EnumSet.noneOf(Element.class);

    protected MessagingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging");
        address.protect();
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(address);
        list.add(subsystemAdd);
        Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
        switch (schemaVer) {
            case MESSAGING_1_0: {
                this.processHornetQServer(reader, address, list, schemaVer);
                break;
            }
            case MESSAGING_1_1: 
            case MESSAGING_1_2: 
            case MESSAGING_1_3: 
            case MESSAGING_1_4: 
            case MESSAGING_1_5: 
            case MESSAGING_2_0: 
            case MESSAGING_3_0: {
                this.processHornetQServers(reader, address, list);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    protected void processHornetQServers(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            switch (schemaVer) {
                case MESSAGING_1_0: 
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HORNETQ_SERVER: {
                    this.processHornetQServer(reader, subsystemAddress, list, schemaVer);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void processHornetQServer(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list, Namespace namespace) throws XMLStreamException {
        String hqServerName = null;
        String elementName = null;
        switch (namespace) {
            case MESSAGING_1_0: {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                elementName = "subsystem";
                break;
            }
            default: {
                int count = reader.getAttributeCount();
                if (count > 0) {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    hqServerName = reader.getAttributeValue(0).trim();
                }
                elementName = "hornetq-server";
            }
        }
        if (hqServerName == null || hqServerName.length() == 0) {
            hqServerName = "default";
        }
        ModelNode address = subsystemAddress.clone();
        address.add("hornetq-server", hqServerName);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        list.add(operation);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        String localName = null;
        block32: do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ACCEPTORS: {
                    this.processAcceptors(reader, address, list);
                    break;
                }
                case ADDRESS_SETTINGS: {
                    this.processAddressSettings(reader, address, list);
                    break;
                }
                case BINDINGS_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "bindings-directory", address, list);
                    break;
                }
                case BRIDGES: {
                    this.processBridges(reader, address, list);
                    break;
                }
                case BROADCAST_GROUPS: {
                    this.processBroadcastGroups(reader, address, list);
                    break;
                }
                case CLUSTER_CONNECTIONS: {
                    this.processClusterConnections(reader, address, list);
                    break;
                }
                case CONNECTORS: {
                    this.processConnectors(reader, address, list);
                    break;
                }
                case CONNECTOR_SERVICES: {
                    MessagingSubsystemParser.processConnectorServices(reader, address, list);
                    break;
                }
                case DISCOVERY_GROUPS: {
                    this.processDiscoveryGroups(reader, address, list);
                    break;
                }
                case DIVERTS: {
                    MessagingSubsystemParser.parseDiverts(reader, address, list);
                    break;
                }
                case FILE_DEPLOYMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUPING_HANDLER: {
                    this.processGroupingHandler(reader, address, list);
                    break;
                }
                case JOURNAL_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "journal-directory", address, list);
                    break;
                }
                case LARGE_MESSAGES_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "large-messages-directory", address, list);
                    break;
                }
                case LIVE_CONNECTOR_REF: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                    MessagingSubsystemParser.skipElementText(reader);
                    break;
                }
                case PAGING_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "paging-directory", address, list);
                    break;
                }
                case REMOTING_INTERCEPTORS: {
                    this.processRemotingInterceptors(reader, operation);
                    break;
                }
                case SECURITY_DOMAIN: {
                    MessagingSubsystemParser.handleElementText(reader, element, null, operation);
                    break;
                }
                case SECURITY_SETTINGS: {
                    this.processSecuritySettings(reader, address, list);
                    break;
                }
                case CORE_QUEUES: {
                    MessagingSubsystemParser.parseQueues(reader, address, list);
                    break;
                }
                case CONNECTION_FACTORIES: {
                    this.processConnectionFactories(reader, address, list);
                    break;
                }
                case JMS_DESTINATIONS: {
                    MessagingSubsystemParser.processJmsDestinations(reader, address, list);
                    break;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "server", operation);
                    break;
                }
                case MESSAGE_COUNTER_ENABLED: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString(), Element.STATISTICS_ENABLED.toString());
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    break;
                }
                case HORNETQ_SERVER: {
                    if (namespace != Namespace.MESSAGING_1_0) continue block32;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case SUBSYSTEM: {
                    if (namespace == Namespace.MESSAGING_1_0) continue block32;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case CLUSTERED: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                }
                default: {
                    if (SIMPLE_ROOT_RESOURCE_ELEMENTS.contains((Object)element)) {
                        AttributeDefinition attributeDefinition = element.getDefinition();
                        if (attributeDefinition instanceof SimpleAttributeDefinition) {
                            MessagingSubsystemParser.handleElementText(reader, element, operation);
                            break;
                        }
                        this.handleComplexConfigurationAttribute(reader, element, operation);
                        break;
                    }
                    this.handleUnknownConfigurationAttribute(reader, element, operation);
                }
            }
        } while (reader.hasNext() && !localName.equals(elementName));
    }

    protected void handleComplexConfigurationAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        throw MessagingLogger.ROOT_LOGGER.unsupportedElement(element.getLocalName());
    }

    protected void handleUnknownConfigurationAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private static void processConnectorServices(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR_SERVICE: {
                    MessagingSubsystemParser.processConnectorService(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void processConnectorService(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode serviceAddress = address.clone().add("connector-service", name);
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress);
        updates.add(add);
        EnumSet<Element> required = EnumSet.of(Element.FACTORY_CLASS);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element) && element != Element.PARAM) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FACTORY_CLASS: {
                    MessagingSubsystemParser.handleElementText(reader, element, add);
                    continue block4;
                }
                case PARAM: {
                    String[] attrs = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.KEY.getLocalName(), Attribute.VALUE.getLocalName()});
                    String key = attrs[0];
                    String value = attrs[1];
                    ModelNode paramAdd = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress.clone().add("param", key));
                    ConnectorServiceParamDefinition.VALUE.parseAndSetParameter(value, paramAdd, (XMLStreamReader)reader);
                    updates.add(paramAdd);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void processClusterConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_CONNECTION: {
                    this.processClusterConnection(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void processClusterConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode clusterConnectionAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("cluster-connection", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.CONNECTOR_REF);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FORWARD_WHEN_NO_CONSUMERS: 
                case MAX_HOPS: {
                    MessagingSubsystemParser.handleElementText(reader, element, clusterConnectionAdd);
                    continue block9;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, ClusterConnectionDefinition.ADDRESS.getName(), clusterConnectionAdd);
                    continue block9;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "simple", clusterConnectionAdd);
                    continue block9;
                }
                case CONFIRMATION_WINDOW_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "bridge", clusterConnectionAdd);
                    continue block9;
                }
                case USE_DUPLICATE_DETECTION: 
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "cluster", clusterConnectionAdd);
                    continue block9;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, clusterConnectionAdd, true);
                    continue block9;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)ClusterConnectionDefinition.DISCOVERY_GROUP_NAME.getXmlName());
                    ClusterConnectionDefinition.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, clusterConnectionAdd, (XMLStreamReader)reader);
                    continue block9;
                }
            }
            this.handleUnknownClusterConnectionAttribute(reader, element, clusterConnectionAdd);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        this.checkClusterConnectionConstraints(reader, seen);
        updates.add(clusterConnectionAdd);
    }

    protected void handleUnknownClusterConnectionAttribute(XMLExtendedStreamReader reader, Element element, ModelNode clusterConnectionAdd) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    protected void checkClusterConnectionConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
    }

    protected void checkBroadcastGroupConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        MessagingSubsystemParser.checkOnlyOneOfElements(reader, seen, Element.GROUP_ADDRESS, Element.SOCKET_BINDING);
        if (seen.contains((Object)Element.GROUP_ADDRESS) && !seen.contains((Object)Element.GROUP_PORT)) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_PORT));
        }
    }

    private void processBridges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BRIDGE: {
                    this.processBridge(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void processBridge(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("bridge", name));
        EnumSet<Element> required = EnumSet.of(Element.QUEUE_NAME);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case QUEUE_NAME: 
                case HA: 
                case TRANSFORMER_CLASS_NAME: 
                case USER: 
                case PASSWORD: {
                    MessagingSubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block10;
                }
                case CONFIRMATION_WINDOW_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block10;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, bridgeAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                case RETRY_INTERVAL: 
                case RETRY_INTERVAL_MULTIPLIER: {
                    MessagingSubsystemParser.handleElementText(reader, element, "default", bridgeAdd);
                    continue block10;
                }
                case USE_DUPLICATE_DETECTION: 
                case FORWARDING_ADDRESS: 
                case RECONNECT_ATTEMPTS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block10;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, bridgeAdd, false);
                    continue block10;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)BridgeDefinition.DISCOVERY_GROUP_NAME.getXmlName());
                    BridgeDefinition.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, (XMLStreamReader)reader);
                    continue block10;
                }
                case FAILOVER_ON_SERVER_SHUTDOWN: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                    MessagingSubsystemParser.skipElementText(reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        MessagingSubsystemParser.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    protected void processStaticConnectors(XMLExtendedStreamReader reader, ModelNode addOperation, boolean cluster) throws XMLStreamException {
        if (cluster) {
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ALLOW_DIRECT_CONNECTIONS_ONLY: {
                        String attrValue = reader.getAttributeValue(i);
                        ClusterConnectionDefinition.ALLOW_DIRECT_CONNECTIONS_ONLY.parseAndSetParameter(attrValue, addOperation, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        } else {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        EnumSet<Element> required = EnumSet.of(Element.CONNECTOR_REF);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, cluster ? "cluster-connection" : "bridge", addOperation);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void processGroupingHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode groupingHandlerAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("grouping-handler", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.TYPE);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case TYPE: 
                case TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, groupingHandlerAdd);
                    continue block4;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, GroupingHandlerDefinition.GROUPING_HANDLER_ADDRESS.getName(), groupingHandlerAdd);
                    continue block4;
                }
            }
            this.handleUnknownGroupingHandlerAttribute(reader, element, groupingHandlerAdd);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(groupingHandlerAdd);
    }

    protected void handleUnknownGroupingHandlerAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    private void processRemotingInterceptors(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS_NAME: {
                    String value = reader.getElementText();
                    CommonAttributes.REMOTING_INTERCEPTORS.parseAndAddParameterElement(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void processBroadcastGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BROADCAST_GROUP: {
                    this.parseBroadcastGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseBroadcastGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = attrValue;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode broadcastGroupAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("broadcast-group", name));
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            seen.add(element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case LOCAL_BIND_PORT: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case SOCKET_BINDING: 
                case BROADCAST_PERIOD: {
                    MessagingSubsystemParser.handleElementText(reader, element, broadcastGroupAdd);
                    continue block8;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "broadcast-group", broadcastGroupAdd);
                    continue block8;
                }
            }
            this.handleUnknownBroadcastGroupAttribute(reader, element, broadcastGroupAdd);
        }
        this.checkBroadcastGroupConstraints(reader, seen);
        updates.add(broadcastGroupAdd);
    }

    protected void handleUnknownBroadcastGroupAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    void processDiscoveryGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP: {
                    this.parseDiscoveryGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseDiscoveryGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = attrValue;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode discoveryGroup = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("discovery-group", name));
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            seen.add(element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case SOCKET_BINDING: 
                case REFRESH_TIMEOUT: 
                case INITIAL_WAIT_TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, discoveryGroup);
                    continue block7;
                }
            }
            this.handleUnknownDiscoveryGroupAttribute(reader, element, discoveryGroup);
        }
        this.checkDiscoveryGroupConstraints(reader, seen);
        updates.add(discoveryGroup);
    }

    protected void handleUnknownDiscoveryGroupAttribute(XMLExtendedStreamReader reader, Element element, ModelNode operation) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    protected void checkDiscoveryGroupConstraints(XMLExtendedStreamReader reader, Set<Element> seen) throws XMLStreamException {
        MessagingSubsystemParser.checkOnlyOneOfElements(reader, seen, Element.GROUP_ADDRESS, Element.SOCKET_BINDING);
        if (seen.contains((Object)Element.GROUP_ADDRESS) && !seen.contains((Object)Element.GROUP_PORT)) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Element.GROUP_PORT));
        }
    }

    void processConnectionFactories(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    this.processConnectionFactory(reader, address, updates);
                    continue block4;
                }
                case POOLED_CONNECTION_FACTORY: {
                    this.processPooledConnectionFactory(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processJmsDestinations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMS_QUEUE: {
                    MessagingSubsystemParser.processJMSQueue(reader, address, updates);
                    continue block4;
                }
                case JMS_TOPIC: {
                    MessagingSubsystemParser.processJMSTopic(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    void processAcceptors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode acceptorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            boolean generic = false;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("acceptor", name));
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    generic = true;
                    break;
                }
                case NETTY_ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("remote-acceptor", name));
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    break;
                }
                case IN_VM_ACCEPTOR: {
                    operation.get("address").set(acceptorAddress.add("in-vm-acceptor", name));
                    if (serverId == null) break;
                    InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            updates.add(operation);
            this.parseTransportConfiguration(reader, operation, generic, updates);
        }
    }

    static void parseQueues(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block7: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case QUEUE: {
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
                    }
                    ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("queue", name));
                    MessagingSubsystemParser.parseQueue(reader, op);
                    if (!op.hasDefined(QueueDefinition.ADDRESS.getName())) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.ADDRESS.getLocalName()));
                    }
                    list.add(op);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseQueue(XMLExtendedStreamReader reader, ModelNode queue) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, QueueDefinition.ADDRESS.getName(), queue);
                    continue block5;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private ModelNode processSecuritySettings(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ModelNode security = new ModelNode();
        String localName = null;
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_SETTING: {
                    String match = reader.getAttributeValue(0);
                    ModelNode addr = address.clone();
                    addr.add("security-setting", match);
                    ModelNode operation = new ModelNode();
                    operation.get("operation").set("add");
                    operation.get("address").set(addr);
                    operations.add(operation);
                    this.parseSecurityRoles(reader, addr, operations);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.SECURITY_SETTING.getLocalName()));
        return security;
    }

    private void parseSecurityRoles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        HashMap<String, HashSet<AttributeDefinition>> permsByRole = new HashMap<String, HashSet<AttributeDefinition>>();
        String localName = null;
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element != Element.PERMISSION_ELEMENT_NAME) break;
            EnumSet<Attribute> required = EnumSet.of(Attribute.ROLES_ATTR_NAME, Attribute.TYPE_ATTR_NAME);
            List<String> roles = null;
            AttributeDefinition perm = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case ROLES_ATTR_NAME: {
                        roles = this.parseRolesAttribute(reader, i);
                        continue block5;
                    }
                    case TYPE_ATTR_NAME: {
                        perm = SecurityRoleDefinition.ROLE_ATTRIBUTES_BY_XML_NAME.get(reader.getAttributeValue(i));
                        if (perm != null) continue block5;
                        throw ControllerLogger.ROOT_LOGGER.invalidAttributeValue(reader.getAttributeValue(i), reader.getAttributeName(i), SecurityRoleDefinition.ROLE_ATTRIBUTES_BY_XML_NAME.keySet(), reader.getLocation());
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            for (String role : roles) {
                HashSet<AttributeDefinition> perms = (HashSet<AttributeDefinition>)permsByRole.get(role = role.trim());
                if (perms == null) {
                    perms = new HashSet<AttributeDefinition>();
                    permsByRole.put(role, perms);
                }
                perms.add(perm);
            }
            reader.discardRemainder();
        } while (reader.hasNext());
        for (Map.Entry entry : permsByRole.entrySet()) {
            String role = (String)entry.getKey();
            Set perms = (Set)entry.getValue();
            ModelNode addr = address.clone();
            addr.add("role", role);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            operation.get("address").set(addr);
            for (SimpleAttributeDefinition perm : SecurityRoleDefinition.ATTRIBUTES) {
                operation.get(perm.getName()).set(perms.contains(perm));
            }
            operations.add(operation);
        }
    }

    protected List<String> parseRolesAttribute(XMLExtendedStreamReader reader, int index) throws XMLStreamException {
        return reader.getListAttributeValue(index);
    }

    void processConnectors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            String serverId = null;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = attrValue;
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode connectorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            boolean generic = false;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("connector", name));
                    if (socketBinding != null) {
                        operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    generic = true;
                    break;
                }
                case NETTY_CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("remote-connector", name));
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(RemoteTransportDefinition.SOCKET_BINDING.getName()).set(socketBinding);
                    break;
                }
                case IN_VM_CONNECTOR: {
                    operation.get("address").set(connectorAddress.add("in-vm-connector", name));
                    if (serverId == null) break;
                    InVMTransportDefinition.SERVER_ID.parseAndSetParameter(serverId, operation, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            updates.add(operation);
            this.parseTransportConfiguration(reader, operation, generic, updates);
        }
    }

    protected void processAddressSettings(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        String localName = null;
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case ADDRESS_SETTING: {
                    String match = reader.getAttributeValue(0);
                    ModelNode operation = this.parseAddressSettings(reader);
                    operation.get("operation").set("add");
                    operation.get("address").set(address);
                    operation.get("address").add("address-setting", match);
                    operations.add(operation);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.ADDRESS_SETTING.getLocalName()));
    }

    protected ModelNode parseAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addressSettingsSpec = new ModelNode();
        do {
            reader.nextTag();
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case DEAD_LETTER_ADDRESS: 
                case EXPIRY_ADDRESS: 
                case REDELIVERY_DELAY: 
                case MAX_SIZE_BYTES: 
                case PAGE_MAX_CACHE_SIZE: 
                case PAGE_SIZE_BYTES: 
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT: 
                case ADDRESS_FULL_MESSAGE_POLICY: 
                case LVQ: 
                case MAX_DELIVERY_ATTEMPTS: 
                case REDISTRIBUTION_DELAY: 
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.handleElementText(reader, element, addressSettingsSpec);
                    break;
                }
                default: {
                    this.handleUnknownAddressSetting(reader, element, addressSettingsSpec);
                }
            }
        } while (!reader.getLocalName().equals(Element.ADDRESS_SETTING.getLocalName()) && reader.getEventType() == 2);
        return addressSettingsSpec;
    }

    protected void handleUnknownAddressSetting(XMLExtendedStreamReader reader, Element element, ModelNode addressSettingsAdd) throws XMLStreamException {
    }

    void parseTransportConfiguration(XMLExtendedStreamReader reader, ModelNode operation, boolean generic, List<ModelNode> updates) throws XMLStreamException {
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FACTORY_CLASS: {
                    if (!generic) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, operation);
                    continue block8;
                }
                case PARAM: {
                    int count = reader.getAttributeCount();
                    String key = null;
                    String value = null;
                    block9: for (int n = 0; n < count; ++n) {
                        String attrName = reader.getAttributeLocalName(n);
                        Attribute attribute = Attribute.forName(attrName);
                        switch (attribute) {
                            case KEY: {
                                key = reader.getAttributeValue(n);
                                continue block9;
                            }
                            case VALUE: {
                                value = reader.getAttributeValue(n);
                                continue block9;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                            }
                        }
                    }
                    ModelNode addParam = new ModelNode();
                    addParam.get("operation").set("add");
                    ModelNode transportAddress = operation.get("address").clone();
                    addParam.get("address").set(transportAddress.add("param", key));
                    TransportParamDefinition.VALUE.parseAndSetParameter(value, addParam, (XMLStreamReader)reader);
                    updates.add(addParam);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseDirectory(XMLExtendedStreamReader reader, String name, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ModelNode path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block4;
                }
                case PATH: {
                    path = PathDefinition.PATHS.get(name).parse(value, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("address").add("path", name);
        operation.get("path").set(path);
        if (relativeTo != null) {
            operation.get("relative-to").set(relativeTo);
        }
        updates.add(operation);
    }

    private static void parseDiverts(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DIVERT: {
                    MessagingSubsystemParser.parseDivert(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDivert(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode divertAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("divert", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.FORWARDING_ADDRESS);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case ROUTING_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, DivertDefinition.ADDRESS.getName(), divertAdd);
                    continue block8;
                }
                case FORWARDING_ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "divert", divertAdd);
                    continue block8;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, divertAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case TRANSFORMER_CLASS_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case EXCLUSIVE: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        list.add(divertAdd);
    }

    static void unhandledElement(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        throw MessagingLogger.ROOT_LOGGER.ignoringUnhandledElement(element, reader.getLocation().toString());
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node) throws XMLStreamException {
        MessagingSubsystemParser.handleElementText(reader, element, null, node);
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, String modelName, ModelNode node) throws XMLStreamException {
        AttributeDefinition attributeDefinition;
        AttributeDefinition attributeDefinition2 = attributeDefinition = modelName == null ? element.getDefinition() : element.getDefinition(modelName);
        if (attributeDefinition != null) {
            String value = reader.getElementText();
            if (attributeDefinition instanceof SimpleAttributeDefinition) {
                ((SimpleAttributeDefinition)attributeDefinition).parseAndSetParameter(value, node, (XMLStreamReader)reader);
            } else if (attributeDefinition instanceof ListAttributeDefinition) {
                ((ListAttributeDefinition)attributeDefinition).parseAndAddParameterElement(value, node, (XMLStreamReader)reader);
            }
        } else {
            MessagingSubsystemParser.handleElementText(reader, element, node, ModelType.STRING, true, false);
        }
    }

    static void skipElementText(XMLExtendedStreamReader reader) throws XMLStreamException {
        reader.getElementText();
    }

    @Deprecated
    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node, ModelType expectedType, boolean allowNull, boolean allowExpression) throws XMLStreamException {
        String value = reader.getElementText();
        if (value != null && value.length() > 0) {
            ModelNode modelValue;
            ModelNode toSet = node.get(element.getLocalName());
            ModelNode modelNode = modelValue = allowExpression ? ParseUtils.parsePossibleExpression((String)value.trim()) : new ModelNode().set(value.trim());
            if (!allowExpression || modelValue.getType() != ModelType.EXPRESSION) {
                toSet.set(modelValue);
            } else {
                try {
                    switch (expectedType) {
                        case BOOLEAN: {
                            toSet.set(modelValue.asBoolean());
                            break;
                        }
                        case BIG_DECIMAL: {
                            toSet.set(modelValue.asBigDecimal());
                            break;
                        }
                        case BIG_INTEGER: {
                            toSet.set(modelValue.asBigInteger());
                            break;
                        }
                        case BYTES: {
                            toSet.set(modelValue.asBytes());
                            break;
                        }
                        case DOUBLE: {
                            toSet.set(modelValue.asDouble());
                            break;
                        }
                        case INT: {
                            toSet.set(modelValue.asInt());
                            break;
                        }
                        case LONG: {
                            toSet.set(modelValue.asLong());
                            break;
                        }
                        case STRING: {
                            toSet.set(modelValue.asString());
                            break;
                        }
                        default: {
                            throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.illegalValue(value, element.getLocalName()), reader.getLocation());
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.illegalValue(value, element.getLocalName(), expectedType), reader.getLocation());
                }
            }
        } else if (!allowNull) {
            throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.illegalValue(value, element.getLocalName()), reader.getLocation());
        }
    }

    static void processJMSTopic(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        topic.get("operation").set("add");
        topic.get("address").set(address).add("jms-topic", name);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.DESTINATION_ENTRIES.parseAndAddParameterElement(entry, topic, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(topic);
    }

    static void processJMSQueue(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode queue = new ModelNode();
        queue.get("operation").set("add");
        queue.get("address").set(address).add("jms-queue", name);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.DESTINATION_ENTRIES.parseAndAddParameterElement(entry, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case SELECTOR: {
                    if (queue.has(CommonAttributes.SELECTOR.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"string");
                    String selector = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.SELECTOR.parseAndSetParameter(selector, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    if (queue.has(CommonAttributes.DURABLE.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(queue);
    }

    void processConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("connection-factory", name);
        updates.add(this.createConnectionFactory(reader, connectionFactory, false));
    }

    void processPooledConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("pooled-connection-factory", name);
        updates.add(this.createConnectionFactory(reader, connectionFactory, true));
    }

    static ModelNode processJmsConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case CONNECTOR_NAME: {
                        name = value.trim();
                        continue block5;
                    }
                    case BACKUP_CONNECTOR_NAME: {
                        MessagingLogger.ROOT_LOGGER.deprecatedXMLAttribute(attribute.toString());
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.CONNECTOR_NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.CONNECTOR_REF) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            connectors.get(name);
        }
        return connectors;
    }

    protected ModelNode createConnectionFactory(XMLExtendedStreamReader reader, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block16: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.getXmlName());
                    ConnectionFactoryAttributes.Common.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, connectionFactory, (XMLStreamReader)reader);
                    continue block16;
                }
                case CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    connectionFactory.get("connector").set(MessagingSubsystemParser.processJmsConnectors(reader));
                    continue block16;
                }
                case ENTRIES: {
                    Element local;
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                        ConnectionFactoryAttributes.Common.ENTRIES.parseAndAddParameterElement(entry, connectionFactory, (XMLStreamReader)reader);
                    }
                    continue block16;
                }
                case HA: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case CLIENT_FAILURE_CHECK_PERIOD: 
                case CALL_TIMEOUT: 
                case CONSUMER_WINDOW_SIZE: 
                case CONSUMER_MAX_RATE: 
                case PRODUCER_WINDOW_SIZE: 
                case PRODUCER_MAX_RATE: 
                case CACHE_LARGE_MESSAGE_CLIENT: 
                case CLIENT_ID: 
                case DUPS_OK_BATCH_SIZE: 
                case TRANSACTION_BATH_SIZE: 
                case BLOCK_ON_ACK: 
                case BLOCK_ON_NON_DURABLE_SEND: 
                case BLOCK_ON_DURABLE_SEND: 
                case AUTO_GROUP: 
                case PRE_ACK: 
                case FAILOVER_ON_INITIAL_CONNECTION: 
                case LOAD_BALANCING_CLASS_NAME: 
                case USE_GLOBAL_POOLS: 
                case GROUP_ID: {
                    MessagingSubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block16;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: 
                case CONFIRMATION_WINDOW_SIZE: 
                case RETRY_INTERVAL: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case RECONNECT_ATTEMPTS: 
                case CONNECTION_TTL: 
                case MAX_RETRY_INTERVAL: 
                case MIN_LARGE_MESSAGE_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "connection", connectionFactory);
                    continue block16;
                }
                case DISCOVERY_INITIAL_WAIT_TIMEOUT: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                    MessagingSubsystemParser.skipElementText(reader);
                    continue block16;
                }
                case CONNECTION_FACTORY_TYPE: {
                    if (pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block16;
                }
                case INBOUND_CONFIG: {
                    Element local;
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block18: while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        switch (local) {
                            case USE_JNDI: 
                            case JNDI_PARAMS: 
                            case USE_LOCAL_TX: 
                            case SETUP_ATTEMPTS: 
                            case SETUP_INTERVAL: {
                                MessagingSubsystemParser.handleElementText(reader, local, connectionFactory);
                                continue block18;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block16;
                }
                case TRANSACTION: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String txType = reader.getAttributeValue(0);
                    if (txType != null) {
                        connectionFactory.get(ConnectionFactoryAttributes.Pooled.TRANSACTION.getName()).set(txType);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block16;
                }
                case USER: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ConnectionFactoryAttributes.Pooled.USER.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block16;
                }
                case PASSWORD: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ConnectionFactoryAttributes.Pooled.PASSWORD.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block16;
                }
            }
            this.handleUnknownConnectionFactoryAttribute(reader, element, connectionFactory, pooled);
        }
        MessagingSubsystemParser.checkOnlyOneOfElements(reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
        return connectionFactory;
    }

    protected void handleUnknownConnectionFactoryAttribute(XMLExtendedStreamReader reader, Element element, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    protected void checkOtherElementIsNotAlreadyDefined(XMLStreamReader reader, Set<Element> seen, Element currentElement, Element otherElement) throws XMLStreamException {
        if (seen.contains((Object)otherElement)) {
            throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.illegalElement(currentElement.getLocalName(), otherElement.getLocalName()), reader.getLocation());
        }
    }

    protected static void checkOnlyOneOfElements(XMLExtendedStreamReader reader, Set<Element> seen, Element element1, Element element2) throws XMLStreamException {
        if (!seen.contains((Object)element1) && !seen.contains((Object)element2)) {
            throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.required(element1.getLocalName(), element2.getLocalName()), reader.getLocation());
        }
        if (seen.contains((Object)element1) && seen.contains((Object)element2)) {
            throw new XMLStreamException(MessagingLogger.ROOT_LOGGER.onlyOneRequired(element1.getLocalName(), element2.getLocalName()), reader.getLocation());
        }
    }

    static {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            SIMPLE_ROOT_RESOURCE_ELEMENTS.add(Element.forName(attr.getXmlName()));
        }
    }
}

