/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.metadata.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.POJOEndpoint;

abstract class AbstractDeployment {
    private final List<EJBEndpoint> ejbEndpoints = new LinkedList<EJBEndpoint>();
    private final List<EJBEndpoint> unmodifiableEjbEndpoints = Collections.unmodifiableList(this.ejbEndpoints);
    private final List<POJOEndpoint> pojoEndpoints = new LinkedList<POJOEndpoint>();
    private final List<POJOEndpoint> unmodifiablePojoEndpoints = Collections.unmodifiableList(this.pojoEndpoints);
    private final Map<String, String> urlPatternToClassMapping = new HashMap<String, String>();

    AbstractDeployment() {
    }

    public List<EJBEndpoint> getEjbEndpoints() {
        return this.unmodifiableEjbEndpoints;
    }

    public List<POJOEndpoint> getPojoEndpoints() {
        return this.unmodifiablePojoEndpoints;
    }

    public void addEndpoint(EJBEndpoint ep) {
        this.ejbEndpoints.add(ep);
    }

    public void addEndpoint(POJOEndpoint ep) {
        String urlPattern = ep.getUrlPattern();
        String className = ep.getClassName();
        if (this.urlPatternToClassMapping.keySet().contains(urlPattern)) {
            String clazz = this.urlPatternToClassMapping.get(urlPattern);
            throw WSLogger.ROOT_LOGGER.sameUrlPatternRequested(clazz, urlPattern, ep.getClassName());
        }
        this.urlPatternToClassMapping.put(urlPattern, className);
        this.pojoEndpoints.add(ep);
    }

    public boolean contains(String urlPattern) {
        return this.urlPatternToClassMapping.keySet().contains(urlPattern);
    }
}

