/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.math.BigInteger;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyTypes;
import org.picketlink.identity.xmlsec.w3.xmlenc.EncryptionMethodType;
import org.w3c.dom.Element;

public class KeyDescriptorMetaDataBuilder {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize, boolean isSigningKey, boolean isEncryptionKey) {
        if (keyInfo == null) {
            throw logger.nullArgumentError("keyInfo");
        }
        if (isSigningKey == isEncryptionKey) {
            throw logger.shouldNotBeTheSameError("Only one of isSigningKey and isEncryptionKey should be true");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull((String)algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        if (isSigningKey) {
            keyDescriptor.setUse(KeyTypes.SIGNING);
        }
        if (isEncryptionKey) {
            keyDescriptor.setUse(KeyTypes.ENCRYPTION);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }

    public static KeyDescriptorType createKeyDescriptor(Element keyInfo, String algorithm, int keySize) {
        if (keyInfo == null) {
            throw logger.nullArgumentError("keyInfo");
        }
        KeyDescriptorType keyDescriptor = new KeyDescriptorType();
        if (StringUtil.isNotNull((String)algorithm)) {
            EncryptionMethodType encryptionMethod = new EncryptionMethodType(algorithm);
            encryptionMethod.setEncryptionMethod(new EncryptionMethodType.EncryptionMethod(BigInteger.valueOf(keySize), null));
            keyDescriptor.addEncryptionMethod(encryptionMethod);
        }
        keyDescriptor.setKeyInfo(keyInfo);
        return keyDescriptor;
    }
}

