/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.protocol;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.jgroups.protocol.CustomProtocol;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Protocol;
import org.wildfly.security.manager.WildFlySecurityManager;

public enum ProtocolFactory implements UnaryOperator<Protocol>
{
    TRANSFORMER;

    private final Map<String, CustomProtocolSource> customProtocols = new HashMap<String, CustomProtocolSource>();

    private ProtocolFactory() {
        short id = 600;
        for (CustomProtocol protocol : ServiceLoader.load(CustomProtocol.class, CustomProtocol.class.getClassLoader())) {
            short s = id;
            id = (short)(id + 1);
            this.customProtocols.put(protocol.getName(), new CustomProtocolSource(s, protocol.getClass()));
        }
    }

    @Override
    public Protocol apply(Protocol protocol) {
        return Optional.ofNullable(this.customProtocols.get(protocol.getName())).map(custom -> custom.get()).orElse(protocol);
    }

    public static <T> T newInstance(Class<? extends T> protocolClass) {
        PrivilegedAction<Object> action = () -> {
            try {
                return protocolClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        };
        return (T)WildFlySecurityManager.doUnchecked(action);
    }

    private static class CustomProtocolSource
    implements Supplier<Protocol> {
        private final Class<? extends CustomProtocol> protocolClass;
        private final short id;

        CustomProtocolSource(short id, Class<? extends CustomProtocol> protocolClass) {
            this.id = id;
            this.protocolClass = protocolClass;
            ClassConfigurator.addProtocol((short)id, protocolClass);
        }

        @Override
        public Protocol get() {
            return ProtocolFactory.newInstance(this.protocolClass).setId(this.id);
        }
    }
}

