/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.CredentialSourceDependency;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenBuilder;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CipherAuthTokenBuilder
extends AuthTokenBuilder<CipherAuthToken> {
    private volatile ValueDependency<KeyStore> keyStore;
    private volatile ValueDependency<CredentialSource> keyCredentialSource;
    private volatile String keyAlias;
    private volatile String transformation;

    public CipherAuthTokenBuilder(PathAddress address) {
        super(address);
    }

    @Override
    public Builder<CipherAuthToken> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStore = CipherAuthTokenResourceDefinition.Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keyStore = new InjectedValueDependency(CommonUnaryRequirement.KEY_STORE.getServiceName(context, keyStore), KeyStore.class);
        this.keyAlias = CipherAuthTokenResourceDefinition.Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keyCredentialSource = new CredentialSourceDependency(context, (Attribute)CipherAuthTokenResourceDefinition.Attribute.KEY_CREDENTIAL, model);
        this.transformation = CipherAuthTokenResourceDefinition.Attribute.ALGORITHM.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<CipherAuthToken> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        Stream.of(this.keyStore, this.keyCredentialSource).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    @Override
    public CipherAuthToken apply(String authValue) {
        KeyStore store = (KeyStore)this.keyStore.getValue();
        String alias = this.keyAlias;
        try {
            if (!store.containsAlias(alias)) {
                throw JGroupsLogger.ROOT_LOGGER.keyEntryNotFound(alias);
            }
            if (!store.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                throw JGroupsLogger.ROOT_LOGGER.privateKeyStoreEntryExpected(alias);
            }
            PasswordCredential credential = (PasswordCredential)((CredentialSource)this.keyCredentialSource.getValue()).getCredential(PasswordCredential.class);
            if (credential == null) {
                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
            }
            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
            if (password == null) {
                throw JGroupsLogger.ROOT_LOGGER.unexpectedCredentialSource();
            }
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(alias, new KeyStore.PasswordProtection(password.getPassword()));
            KeyPair pair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
            Cipher cipher = Cipher.getInstance(this.transformation);
            return new CipherAuthToken(cipher, pair, authValue.getBytes());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

