/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyInfo {
    private final Map<String, Site> allSites = new HashMap<String, Site>();
    private List<Rack> allRacks = new ArrayList<Rack>();
    private List<Machine> allMachines = new ArrayList<Machine>();
    private List<Address> sortedNodes;
    private Map<Address, Float> capacityFactors;
    private Map<Address, Float> maxSegments;

    public TopologyInfo(Collection<Address> members, Map<Address, Float> capacityFactors) {
        this.capacityFactors = capacityFactors;
        this.sortedNodes = this.sortMembers(members, capacityFactors);
        for (Address node : this.sortedNodes) {
            if (capacityFactors != null && (double)capacityFactors.get(node).floatValue() == 0.0) continue;
            this.addTopology(node);
        }
    }

    private List<Address> sortMembers(Collection<Address> members, final Map<Address, Float> capacityFactors) {
        ArrayList<Address> sortedList = new ArrayList<Address>(members);
        Collections.sort(sortedList, new Comparator<Address>(){

            @Override
            public int compare(Address o1, Address o2) {
                int capacityComparison = capacityFactors != null ? ((Float)capacityFactors.get(o1)).compareTo((Float)capacityFactors.get(o2)) : 0;
                return capacityComparison != 0 ? -capacityComparison : o1.compareTo(o2);
            }
        });
        return sortedList;
    }

    private void addTopology(Address node) {
        Machine machine;
        Rack rack;
        TopologyAwareAddress taNode = (TopologyAwareAddress)node;
        String siteId = taNode.getSiteId();
        String rackId = taNode.getRackId();
        String machineId = taNode.getMachineId();
        Site site = this.allSites.get(siteId);
        if (site == null) {
            site = new Site(siteId);
            this.allSites.put(siteId, site);
        }
        if ((rack = site.racks.get(rackId)) == null) {
            rack = new Rack(siteId, rackId);
            site.racks.put(rackId, rack);
            this.allRacks.add(rack);
        }
        if ((machine = rack.machines.get(machineId)) == null) {
            machine = new Machine(siteId, rackId, machineId);
            rack.machines.put(machineId, machine);
            this.allMachines.add(machine);
        }
        machine.nodes.add(node);
        rack.nodes.add(node);
        site.nodes.add(node);
    }

    public Collection<Address> getSiteNodes(String site) {
        return this.allSites.get((Object)site).nodes;
    }

    public Collection<Address> getRackNodes(String site, String rack) {
        return this.allSites.get((Object)site).racks.get((Object)rack).nodes;
    }

    public Collection<Address> getMachineNodes(String site, String rack, String machine) {
        return this.allSites.get((Object)site).racks.get((Object)rack).machines.get((Object)machine).nodes;
    }

    public Set<String> getAllSites() {
        return this.allSites.keySet();
    }

    public Set<String> getSiteRacks(String site) {
        return this.allSites.get((Object)site).racks.keySet();
    }

    public Set<String> getRackMachines(String site, String rack) {
        return this.allSites.get((Object)site).racks.get((Object)rack).machines.keySet();
    }

    public int getAllSitesCount() {
        return this.allSites.size();
    }

    public int getAllRacksCount() {
        return this.allRacks.size();
    }

    public int getAllMachinesCount() {
        return this.allMachines.size();
    }

    public int getAllNodesCount() {
        return this.sortedNodes.size();
    }

    public int getDistinctLocationsCount(TopologyLevel level, int numOwners) {
        switch (level) {
            case NODE: {
                return Math.min(numOwners, this.getAllNodesCount());
            }
            case MACHINE: {
                return Math.min(numOwners, this.getAllMachinesCount());
            }
            case RACK: {
                return Math.min(numOwners, this.getAllRacksCount());
            }
            case SITE: {
                return Math.min(numOwners, this.getAllSitesCount());
            }
        }
        throw new IllegalArgumentException("Unexpected topology level: " + (Object)((Object)level));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TopologyInfo{\n");
        for (Map.Entry<String, Site> site : this.allSites.entrySet()) {
            String siteId = site.getKey();
            sb.append(String.format("%s: {", siteId));
            for (Map.Entry<String, Rack> rack : site.getValue().racks.entrySet()) {
                String rackId = rack.getKey();
                sb.append(String.format("%s: {", rackId));
                for (Map.Entry<String, Machine> machine : rack.getValue().machines.entrySet()) {
                    String machineId = machine.getKey();
                    sb.append(String.format("%s: {", machineId));
                    for (Address node : machine.getValue().nodes) {
                        sb.append(node);
                        sb.append(", ");
                    }
                    sb.setLength(sb.length() - 2);
                    sb.append("}, ");
                }
                sb.setLength(sb.length() - 3);
                sb.append("}, ");
            }
            sb.setLength(sb.length() - 3);
            sb.append("}, ");
        }
        sb.setLength(sb.length() - 3);
        sb.append('}');
        return sb.toString();
    }

    private double computeMaxSegmentsForNode(int numSegments, double numCopies, Collection<Address> nodes, Address node) {
        if (this.capacityFactors == null) {
            if ((double)nodes.size() < numCopies) {
                return numSegments;
            }
            return numCopies * (double)numSegments / (double)nodes.size();
        }
        Float nodeCapacityFactor = this.capacityFactors.get(node);
        if (nodeCapacityFactor.floatValue() == 0.0f) {
            return 0.0;
        }
        double remainingCapacity = this.computeTotalCapacity(nodes, this.capacityFactors);
        double remainingCopies = numCopies * (double)numSegments;
        for (Address a : nodes) {
            float capacityFactor = this.capacityFactors.get(a).floatValue();
            double nodeSegments = (double)capacityFactor / remainingCapacity * remainingCopies;
            if (nodeSegments > (double)numSegments) {
                nodeSegments = numSegments;
                remainingCapacity -= (double)capacityFactor;
                remainingCopies -= nodeSegments;
                if (!node.equals(a)) continue;
                return nodeSegments;
            }
            if (!node.equals(a)) {
                nodeSegments = (double)nodeCapacityFactor.floatValue() / remainingCapacity * remainingCopies;
            }
            return nodeSegments;
        }
        throw new IllegalStateException("The nodes collection does not include " + node);
    }

    public float computeTotalCapacity(Collection<Address> nodes, Map<Address, Float> capacityFactors) {
        if (capacityFactors == null) {
            return nodes.size();
        }
        float totalCapacity = 0.0f;
        for (Address node : nodes) {
            totalCapacity += capacityFactors.get(node).floatValue();
        }
        return totalCapacity;
    }

    private double computeMaxSegmentsForMachine(int numSegments, double numCopies, Collection<Machine> machines, Machine machine, Address node) {
        double copiesPerMachine = numCopies / (double)machines.size();
        if ((double)machine.nodes.size() <= copiesPerMachine) {
            copiesPerMachine = 1.0;
        } else {
            int fullMachines = 0;
            for (Machine m : machines) {
                if (!((double)m.nodes.size() <= copiesPerMachine)) continue;
                ++fullMachines;
            }
            copiesPerMachine = (numCopies - (double)fullMachines) / (double)(machines.size() - fullMachines);
        }
        return this.computeMaxSegmentsForNode(numSegments, copiesPerMachine, machine.nodes, node);
    }

    private double computeMaxSegmentsForRack(int numSegments, double numCopies, Collection<Rack> racks, Rack rack, Machine machine, Address node) {
        double copiesPerRack = numCopies / (double)racks.size();
        if ((double)rack.machines.size() <= copiesPerRack) {
            copiesPerRack = 1.0;
        } else {
            int fullRacks = 0;
            for (Rack m : racks) {
                if (!((double)m.machines.size() <= copiesPerRack)) continue;
                ++fullRacks;
            }
            copiesPerRack = (numCopies - (double)fullRacks) / (double)(racks.size() - fullRacks);
        }
        if (copiesPerRack <= 1.0) {
            return this.computeMaxSegmentsForNode(numSegments, copiesPerRack, rack.nodes, node);
        }
        return this.computeMaxSegmentsForMachine(numSegments, copiesPerRack, rack.machines.values(), machine, node);
    }

    private double computeMaxSegmentsForSite(int numSegments, double numCopies, Collection<Site> sites, Site site, Rack rack, Machine machine, Address node) {
        double copiesPerSite = numCopies / (double)sites.size();
        if ((double)site.racks.size() <= copiesPerSite) {
            copiesPerSite = 1.0;
        } else {
            int fullSites = 0;
            for (Site s : sites) {
                if (!((double)s.racks.size() <= copiesPerSite)) continue;
                ++fullSites;
            }
            copiesPerSite = (numCopies - (double)fullSites) / (double)(sites.size() - fullSites);
        }
        if (copiesPerSite <= 1.0) {
            return this.computeMaxSegmentsForNode(numSegments, copiesPerSite, site.nodes, node);
        }
        return this.computeMaxSegmentsForRack(numSegments, copiesPerSite, site.racks.values(), rack, machine, node);
    }

    public int computeExpectedSegments(int numSegments, int numOwners, Address node) {
        if (this.capacityFactors != null && (double)this.capacityFactors.get(node).floatValue() == 0.0) {
            return 0;
        }
        TopologyAwareAddress taa = (TopologyAwareAddress)node;
        String siteId = taa.getSiteId();
        String rackId = taa.getRackId();
        String machineId = taa.getMachineId();
        Site site = this.allSites.get(siteId);
        Rack rack = site.racks.get(rackId);
        Machine machine = rack.machines.get(machineId);
        double maxSegments = numOwners == 1 ? this.computeMaxSegmentsForNode(numSegments, numOwners, this.sortedNodes, node) : (this.getAllNodesCount() <= numOwners ? (double)numSegments : (this.getAllMachinesCount() <= numOwners ? this.computeMaxSegmentsForMachine(numSegments, numOwners, this.allMachines, machine, node) : (this.getAllRacksCount() <= numOwners ? this.computeMaxSegmentsForRack(numSegments, numOwners, this.allRacks, rack, machine, node) : this.computeMaxSegmentsForSite(numSegments, numOwners, this.allSites.values(), site, rack, machine, node))));
        return (int)Math.round(maxSegments);
    }

    private static class Machine {
        String site;
        String rack;
        String machine;
        List<Address> nodes = new ArrayList<Address>();

        private Machine(String site, String rack, String machine) {
            this.site = site;
            this.rack = rack;
            this.machine = machine;
        }
    }

    private static class Rack {
        String site;
        String rack;
        Map<String, Machine> machines = new HashMap<String, Machine>();
        List<Address> nodes = new ArrayList<Address>();

        private Rack(String site, String rack) {
            this.site = site;
            this.rack = rack;
        }
    }

    private static class Site {
        String site;
        Map<String, Rack> racks = new HashMap<String, Rack>();
        List<Address> nodes = new ArrayList<Address>();

        private Site(String site) {
            this.site = site;
        }
    }
}

