/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ScheduledThreadPoolService;
import org.jboss.as.threads.ThreadPoolMetricsHandler;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public class ScheduledThreadPoolMetricsHandler
extends ThreadPoolMetricsHandler {
    public static final List<AttributeDefinition> METRICS = Arrays.asList(PoolAttributeDefinitions.ACTIVE_COUNT, PoolAttributeDefinitions.COMPLETED_TASK_COUNT, PoolAttributeDefinitions.CURRENT_THREAD_COUNT, PoolAttributeDefinitions.LARGEST_THREAD_COUNT, PoolAttributeDefinitions.TASK_COUNT, PoolAttributeDefinitions.QUEUE_SIZE);

    public ScheduledThreadPoolMetricsHandler(ServiceName serviceNameBase) {
        super(METRICS, serviceNameBase);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        ScheduledThreadPoolService pool = (ScheduledThreadPoolService)service;
        if (attributeName.equals("active-count")) {
            context.getResult().set(pool.getActiveCount());
        } else if (attributeName.equals("completed-task-count")) {
            context.getResult().set(pool.getCompletedTaskCount());
        } else if (attributeName.equals("current-thread-count")) {
            context.getResult().set(pool.getCurrentThreadCount());
        } else if (attributeName.equals("largest-thread-count")) {
            context.getResult().set(pool.getLargestThreadCount());
        } else if (attributeName.equals("task-count")) {
            context.getResult().set(pool.getTaskCount());
        } else if (attributeName.equals("queue-size")) {
            context.getResult().set(pool.getQueueSize());
        } else {
            throw ThreadsLogger.ROOT_LOGGER.unsupportedScheduledThreadPoolMetric(attributeName);
        }
    }
}

