/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.encoder;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.picketlink.idm.credential.encoder.PasswordEncoder;

public class PBKDF2PasswordEncoder
implements PasswordEncoder {
    private final byte[] salt;
    private final int keyLength;
    private final int iterationCount;
    public static final String ALGO = "PBKDF2WithHmacSHA1";

    public PBKDF2PasswordEncoder(byte[] salt, int iterationCount, int keyLength) {
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.keyLength = keyLength;
    }

    @Override
    public String encode(String rawPassword) {
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(ALGO);
            PBEKeySpec keySpec = new PBEKeySpec(rawPassword.toCharArray(), this.salt, this.iterationCount, this.keyLength);
            try {
                SecretKey secretKey = secretKeyFactory.generateSecret(keySpec);
                return new String(secretKey.getEncoded());
            }
            catch (InvalidKeySpecException ikse) {
                throw new RuntimeException(ikse);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    @Override
    public boolean verify(String rawPassword, String encodedPassword) {
        return this.encode(rawPassword).equals(encodedPassword);
    }
}

