/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.model.host;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum AdminOnlyDomainConfigPolicy {
    ALLOW_NO_CONFIG("allow-no-config"),
    FETCH_FROM_MASTER("fetch-from-master"),
    REQUIRE_LOCAL_CONFIG("require-local-config");

    public static final AdminOnlyDomainConfigPolicy DEFAULT;
    private final String toString;
    private static final Map<String, AdminOnlyDomainConfigPolicy> POLICY_MAP;

    private AdminOnlyDomainConfigPolicy(String toString) {
        this.toString = toString;
    }

    public String toString() {
        return this.toString;
    }

    public static AdminOnlyDomainConfigPolicy getPolicy(String stringForm) {
        AdminOnlyDomainConfigPolicy result = POLICY_MAP.get(stringForm.toUpperCase(Locale.ENGLISH));
        if (result == null) {
            result = AdminOnlyDomainConfigPolicy.valueOf(stringForm);
        }
        return result;
    }

    static {
        DEFAULT = ALLOW_NO_CONFIG;
        POLICY_MAP = new HashMap<String, AdminOnlyDomainConfigPolicy>();
        for (AdminOnlyDomainConfigPolicy policy : AdminOnlyDomainConfigPolicy.values()) {
            POLICY_MAP.put(policy.toString().toUpperCase(Locale.ENGLISH), policy);
        }
    }
}

