/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractIdMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AttributeProcessorHelper;
import org.jboss.metadata.ejb.parser.spec.CmpFieldMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.QueryMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.SecurityIdentityParser;
import org.jboss.metadata.ejb.spec.AbstractGenericBeanMetaData;
import org.jboss.metadata.ejb.spec.CMPFieldMetaData;
import org.jboss.metadata.ejb.spec.CMPFieldsMetaData;
import org.jboss.metadata.ejb.spec.EjbType;
import org.jboss.metadata.ejb.spec.GenericBeanMetaData;
import org.jboss.metadata.ejb.spec.PersistenceType;
import org.jboss.metadata.ejb.spec.QueriesMetaData;
import org.jboss.metadata.ejb.spec.QueryMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.EnvironmentRefsGroupMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;
import org.jboss.metadata.parser.ee.EnvironmentRefsGroupMetaDataParser;
import org.jboss.metadata.parser.ee.SecurityRoleRefMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;

public class EntityBeanMetaDataParser
extends AbstractIdMetaDataParser<AbstractGenericBeanMetaData> {
    @Override
    public AbstractGenericBeanMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        GenericBeanMetaData bean = new GenericBeanMetaData(EjbType.ENTITY);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (EntityBeanMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.ID) continue;
            bean.setId(reader.getAttributeValue(i));
        }
        AttributeProcessorHelper.processAttributes(bean, reader, this);
        this.processElements(bean, reader, propertyReplacer);
        return bean;
    }

    @Override
    protected void processElement(AbstractGenericBeanMetaData beanMetaData, XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        DescriptionGroupMetaData descriptionGroup = new DescriptionGroupMetaData();
        if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (DescriptionGroupMetaData)descriptionGroup)) {
            if (beanMetaData.getDescriptionGroup() == null) {
                beanMetaData.setDescriptionGroup(descriptionGroup);
            }
            return;
        }
        Environment jndiEnvRefGroup = beanMetaData.getJndiEnvironmentRefsGroup();
        if (jndiEnvRefGroup == null) {
            jndiEnvRefGroup = new EnvironmentRefsGroupMetaData();
            beanMetaData.setJndiEnvironmentRefsGroup(jndiEnvRefGroup);
        }
        if (jndiEnvRefGroup instanceof EnvironmentRefsGroupMetaData && EnvironmentRefsGroupMetaDataParser.parse((XMLStreamReader)reader, (EnvironmentRefsGroupMetaData)((EnvironmentRefsGroupMetaData)jndiEnvRefGroup), (PropertyReplacer)propertyReplacer)) {
            return;
        }
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case EJB_NAME: {
                beanMetaData.setEjbName(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case MAPPED_NAME: {
                beanMetaData.setMappedName(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case HOME: {
                beanMetaData.setHome(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case REMOTE: {
                beanMetaData.setRemote(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case LOCAL_HOME: {
                beanMetaData.setLocalHome(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case LOCAL: {
                beanMetaData.setLocal(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case EJB_CLASS: {
                beanMetaData.setEjbClass(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case PERSISTENCE_TYPE: {
                PersistenceType persistenceType = this.processPersistenceType(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                if (persistenceType == null) {
                    throw EntityBeanMetaDataParser.unexpectedValue((XMLStreamReader)reader, (Throwable)new Exception("Unexpected value: " + (Object)((Object)persistenceType) + " for persistence-type"));
                }
                beanMetaData.setPersistenceType(persistenceType);
                return;
            }
            case PRIM_KEY_CLASS: {
                beanMetaData.setPrimKeyClass(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case REENTRANT: {
                beanMetaData.setReentrant(Boolean.parseBoolean(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer)));
                return;
            }
            case CMP_VERSION: {
                beanMetaData.setCmpVersion(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case ABSTRACT_SCHEMA_NAME: {
                beanMetaData.setAbstractSchemaName(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case CMP_FIELD: {
                CMPFieldMetaData field = CmpFieldMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                CMPFieldsMetaData fields = beanMetaData.getCmpFields();
                if (fields == null) {
                    fields = new CMPFieldsMetaData();
                    beanMetaData.setCmpFields(fields);
                }
                fields.add((MappableMetaData)field);
                return;
            }
            case PRIMKEY_FIELD: {
                beanMetaData.setPrimKeyField(EntityBeanMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                return;
            }
            case SECURITY_ROLE_REF: {
                SecurityRoleRefsMetaData securityRoleRefs = beanMetaData.getSecurityRoleRefs();
                if (securityRoleRefs == null) {
                    securityRoleRefs = new SecurityRoleRefsMetaData();
                    beanMetaData.setSecurityRoleRefs(securityRoleRefs);
                }
                SecurityRoleRefMetaData securityRoleRef = SecurityRoleRefMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                securityRoleRefs.add((MappableMetaData)securityRoleRef);
                return;
            }
            case SECURITY_IDENTITY: {
                SecurityIdentityMetaData securityIdentity = SecurityIdentityParser.INSTANCE.parse(reader, propertyReplacer);
                beanMetaData.setSecurityIdentity(securityIdentity);
                return;
            }
            case QUERY: {
                QueryMetaData query = QueryMetaDataParser.INSTANCE.parse(reader, propertyReplacer);
                QueriesMetaData queries = beanMetaData.getQueries();
                if (queries == null) {
                    queries = new QueriesMetaData();
                    beanMetaData.setQueries(queries);
                }
                queries.add(query);
                return;
            }
        }
        throw EntityBeanMetaDataParser.unexpectedElement((XMLStreamReader)reader);
    }

    protected PersistenceType processPersistenceType(String persistenceType) {
        if (persistenceType.equals("Container")) {
            return PersistenceType.Container;
        }
        if (persistenceType.equals("Bean")) {
            return PersistenceType.Bean;
        }
        return null;
    }
}

