/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.time.LocalDateExternalizer;
import org.wildfly.clustering.marshalling.spi.time.LocalTimeExternalizer;

public class LocalDateTimeExternalizer
implements Externalizer<LocalDateTime> {
    private static final Externalizer<LocalDate> DATE_EXTERNALIZER = new LocalDateExternalizer();
    private static final Externalizer<LocalTime> TIME_EXTERNALIZER = new LocalTimeExternalizer();

    public void writeObject(ObjectOutput output, LocalDateTime dateTime) throws IOException {
        DATE_EXTERNALIZER.writeObject(output, (Object)dateTime.toLocalDate());
        TIME_EXTERNALIZER.writeObject(output, (Object)dateTime.toLocalTime());
    }

    public LocalDateTime readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        LocalDate date = (LocalDate)DATE_EXTERNALIZER.readObject(input);
        LocalTime time = (LocalTime)TIME_EXTERNALIZER.readObject(input);
        return LocalDateTime.of(date, time);
    }

    public Class<LocalDateTime> getTargetClass() {
        return LocalDateTime.class;
    }
}

