/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.IndexExternalizer;
import org.wildfly.clustering.marshalling.spi.util.MapExternalizer;

public class SortedMapExternalizer<T extends SortedMap<Object, Object>>
implements Externalizer<T> {
    private final Class<T> targetClass;
    private final Function<Comparator<? super Object>, T> factory;

    SortedMapExternalizer(Class<?> targetClass, Function<Comparator<? super Object>, T> factory) {
        this.targetClass = targetClass;
        this.factory = factory;
    }

    public void writeObject(ObjectOutput output, T map) throws IOException {
        output.writeObject(map.comparator());
        MapExternalizer.writeMap(output, map);
    }

    public T readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        Comparator comparator = (Comparator)input.readObject();
        int size = IndexExternalizer.VARIABLE.readData(input);
        return (T)((SortedMap)MapExternalizer.readMap(input, (Map)this.factory.apply(comparator), size));
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public static class TreeMapExternalizer
    extends SortedMapExternalizer<TreeMap<Object, Object>> {
        public TreeMapExternalizer() {
            super(TreeMap.class, TreeMap::new);
        }
    }

    public static class ConcurrentSkipListMapExternalizer
    extends SortedMapExternalizer<ConcurrentSkipListMap<Object, Object>> {
        public ConcurrentSkipListMapExternalizer() {
            super(ConcurrentSkipListMap.class, ConcurrentSkipListMap::new);
        }
    }
}

