/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cmp.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.cmp.subsystem.Attribute;
import org.jboss.as.cmp.subsystem.Element;
import org.jboss.as.cmp.subsystem.HiLoKeyGeneratorResourceDefinition;
import org.jboss.as.cmp.subsystem.Namespace;
import org.jboss.as.cmp.subsystem.UUIDKeyGeneratorResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class CmpSubsystem10Parser
implements XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    protected CmpSubsystem10Parser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.EMPTY_ADDRESS.append("subsystem", "cmp");
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ModelNode cmpSubsystem = Util.createAddOperation((PathAddress)address);
        operations.add(cmpSubsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case KEY_GENERATORS: {
                    this.parseKeyGenerators(reader, operations, address);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseKeyGenerators(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress parentAddress) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case UUID: {
                    operations.add(this.parseUuid(reader, parentAddress));
                    continue block4;
                }
                case HILO: {
                    operations.add(this.parseHilo(reader, parentAddress));
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected ModelNode parseUuid(XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode op = Util.createAddOperation((PathAddress)parentAddress.append("uuid-keygenerator", name));
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        return op;
    }

    protected ModelNode parseHilo(XMLExtendedStreamReader reader, PathAddress parentAddress) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block3: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode op = Util.createAddOperation((PathAddress)parentAddress.append("hilo-keygenerator", name));
        EnumSet<Element> required = EnumSet.of(Element.DATA_SOURCE, Element.TABLE_NAME, Element.ID_COLUMN, Element.SEQUENCE_COLUMN, Element.SEQUENCE_NAME);
        while (reader.hasNext() && reader.nextTag() != 2) {
            String value = reader.getElementText();
            String tag = reader.getLocalName();
            Element element = Element.forName(tag);
            required.remove((Object)element);
            SimpleAttributeDefinition attribute = HiLoKeyGeneratorResourceDefinition.ATTRIBUTE_MAP.get(tag);
            if (attribute == null) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            attribute.parseAndSetParameter(value, op, (XMLStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        return op;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode model = context.getModelNode();
        if (model.hasDefined("uuid-keygenerator") || model.hasDefined("hilo-keygenerator")) {
            ModelNode keyGenModel;
            String name;
            writer.writeStartElement(Element.KEY_GENERATORS.getLocalName());
            if (model.hasDefined("uuid-keygenerator")) {
                for (Property keyGen : model.get("uuid-keygenerator").asPropertyList()) {
                    name = keyGen.getName();
                    keyGenModel = keyGen.getValue();
                    this.writeUuid(writer, name, keyGenModel);
                }
            }
            if (model.hasDefined("hilo-keygenerator")) {
                for (Property keyGen : model.get("hilo-keygenerator").asPropertyList()) {
                    name = keyGen.getName();
                    keyGenModel = keyGen.getValue();
                    this.writeHilo(writer, name, keyGenModel);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeHilo(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.HILO.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        HiLoKeyGeneratorResourceDefinition.JNDI_NAME.marshallAsAttribute(model, (XMLStreamWriter)writer);
        for (SimpleAttributeDefinition attribute : HiLoKeyGeneratorResourceDefinition.ATTRIBUTES) {
            if (attribute.equals(HiLoKeyGeneratorResourceDefinition.JNDI_NAME)) continue;
            attribute.marshallAsElement(model, (XMLStreamWriter)writer);
        }
        writer.writeEndElement();
    }

    private void writeUuid(XMLExtendedStreamWriter writer, String name, ModelNode model) throws XMLStreamException {
        writer.writeStartElement(Element.UUID.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), name);
        UUIDKeyGeneratorResourceDefinition.JNDI_NAME.marshallAsAttribute(model, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }
}

