/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.util.Collections;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.atomic.AtomicMap;
import org.infinispan.atomic.FineGrainedAtomicMap;
import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.atomic.impl.AtomicHashMapProxy;
import org.infinispan.atomic.impl.FineGrainedAtomicHashMapProxy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.context.Flag;

public class AtomicMapLookup {
    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key) {
        return AtomicMapLookup.getAtomicMap(cache, key, true);
    }

    public static <MK, K, V> FineGrainedAtomicMap<K, V> getFineGrainedAtomicMap(Cache<MK, ?> cache, MK key) {
        return AtomicMapLookup.getFineGrainedAtomicMap(cache, key, true);
    }

    public static <MK, K, V> AtomicMap<K, V> getAtomicMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent) {
        return (AtomicMap)AtomicMapLookup.getMap(cache, key, createIfAbsent, false);
    }

    public static <MK, K, V> FineGrainedAtomicMap<K, V> getFineGrainedAtomicMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent) {
        return (FineGrainedAtomicMap)AtomicMapLookup.getMap(cache, key, createIfAbsent, true);
    }

    private static <MK, K, V> Map<K, V> getMap(Cache<MK, ?> cache, MK key, boolean createIfAbsent, boolean fineGrained) {
        AtomicHashMap castValue;
        AtomicHashMapProxy proxy;
        boolean typeSwitchAttempt;
        AtomicHashMap value = cache.get(key);
        if (value == null) {
            if (createIfAbsent) {
                value = AtomicHashMap.newInstance(cache, key, fineGrained ? AtomicHashMap.ProxyMode.FINE : AtomicHashMap.ProxyMode.COARSE);
            } else {
                return null;
            }
        }
        boolean bl = typeSwitchAttempt = (proxy = (castValue = (AtomicHashMap)value).getProxy(cache.getAdvancedCache(), key)) instanceof FineGrainedAtomicHashMapProxy != fineGrained;
        if (typeSwitchAttempt) {
            throw new IllegalArgumentException("Cannot switch type of previously used " + value + " from " + (fineGrained ? "regular to fine-grained!" : "fine-grained to regular!"));
        }
        return proxy;
    }

    public static <MK, K, V> Map<K, V> getReadOnlyAtomicMap(Cache<MK, ?> cache, MK key) {
        AtomicMap<K, V> am = AtomicMapLookup.getAtomicMap(cache, key, false);
        if (am == null) {
            return Collections.emptyMap();
        }
        return Immutables.immutableMapWrap(am);
    }

    public static <MK> void removeAtomicMap(Cache<MK, ?> cache, MK key) {
        cache.getAdvancedCache().withFlags(Flag.IGNORE_RETURN_VALUES).remove(key);
    }
}

