/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.injection.InjectionTargets;
import org.jboss.as.weld.injection.WeldInjectionContext;
import org.jboss.as.weld.spi.ComponentSupport;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.ejb.spi.EjbDescriptor;
import org.jboss.weld.injection.producer.InjectionTargetService;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.manager.api.WeldInjectionTarget;
import org.jboss.weld.manager.api.WeldManager;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldComponentService
implements Service<WeldComponentService> {
    private final Class<?> componentClass;
    private final InjectedValue<WeldBootstrapService> weldContainer;
    private final String ejbName;
    private final Set<Class<?>> interceptorClasses;
    private final Map<Class<?>, InjectionTarget> interceptorInjections = new HashMap();
    private final ClassLoader classLoader;
    private final String beanDeploymentArchiveId;
    private final ComponentDescription componentDescription;
    private final boolean isComponentWithView;
    private final boolean delegateProduce;
    private InjectionTarget injectionTarget;
    private Bean<?> bean;
    private BeanManagerImpl beanManager;

    public WeldComponentService(Class<?> componentClass, String ejbName, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId, boolean delegateProduce, ComponentDescription componentDescription, boolean isComponentWithView) {
        this.componentClass = componentClass;
        this.ejbName = ejbName;
        this.beanDeploymentArchiveId = beanDeploymentArchiveId;
        this.delegateProduce = delegateProduce;
        this.weldContainer = new InjectedValue();
        this.interceptorClasses = interceptorClasses;
        this.classLoader = classLoader;
        this.componentDescription = componentDescription;
        this.isComponentWithView = isComponentWithView;
    }

    public WeldInjectionContext createInjectionContext() {
        return new WeldInjectionContext((CreationalContext<?>)this.beanManager.createCreationalContext(this.bean), this.bean, this.delegateProduce, this.injectionTarget, this.interceptorInjections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        ClassLoader cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            EjbDescriptor descriptor;
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
            this.beanManager = ((WeldBootstrapService)this.weldContainer.getValue()).getBeanManager(this.beanDeploymentArchiveId);
            for (Class<?> interceptor : this.interceptorClasses) {
                AnnotatedType type = this.beanManager.createAnnotatedType(interceptor);
                WeldInjectionTarget injectionTarget = this.beanManager.getInjectionTargetFactory(type).createInterceptorInjectionTarget();
                this.interceptorInjections.put(interceptor, this.beanManager.fireProcessInjectionTarget(type, (InjectionTarget)injectionTarget));
            }
            if (this.ejbName != null && (descriptor = this.beanManager.getEjbDescriptor(this.ejbName)) != null) {
                this.bean = this.beanManager.getBean(descriptor);
            }
            if (this.bean instanceof SessionBean) {
                SessionBean sessionBean = (SessionBean)this.bean;
                this.injectionTarget = sessionBean.getInjectionTarget();
                return;
            }
            WeldInjectionTarget<?> injectionTarget = InjectionTargets.createInjectionTarget(this.componentClass, this.bean, this.beanManager, !this.isComponentWithView);
            for (ComponentSupport support : ServiceLoader.load(ComponentSupport.class, WildFlySecurityManager.getClassLoaderPrivileged(WeldComponentService.class))) {
                if (!support.isProcessing(this.componentDescription)) continue;
                this.injectionTarget = support.processInjectionTarget(injectionTarget, this.componentDescription, (WeldManager)this.beanManager);
                break;
            }
            if (this.injectionTarget == null) {
                this.injectionTarget = injectionTarget;
            }
            ((InjectionTargetService)this.beanManager.getServices().get(InjectionTargetService.class)).validateProducer(injectionTarget);
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)cl);
        }
    }

    public synchronized void stop(StopContext context) {
        this.injectionTarget = null;
        this.interceptorInjections.clear();
        this.bean = null;
    }

    public synchronized WeldComponentService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<WeldBootstrapService> getWeldContainer() {
        return this.weldContainer;
    }

    public InjectionTarget getInjectionTarget() {
        return this.injectionTarget;
    }
}

