/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util.concurrent.jdk8backported;

import org.infinispan.commons.util.concurrent.jdk8backported.AbstractEntrySizeCalculatorHelper;
import org.infinispan.commons.util.concurrent.jdk8backported.EntrySizeCalculator;

public final class NodeSizeCalculatorWrapper<K, V>
extends AbstractEntrySizeCalculatorHelper<K, V> {
    private final EntrySizeCalculator<? super K, ? super V> calculator;
    private final long nodeAverageSize;

    public NodeSizeCalculatorWrapper(EntrySizeCalculator<? super K, ? super V> calculator) {
        this.calculator = calculator;
        long calculateNodeAverageSize = OBJECT_SIZE + POINTER_SIZE;
        calculateNodeAverageSize += (long)(5 * POINTER_SIZE);
        long lruNodeSize = this.calculateLRUNodeSize();
        this.nodeAverageSize = this.roundUpToNearest8(calculateNodeAverageSize += 4L) + lruNodeSize;
    }

    private long calculateLRUNodeSize() {
        long size = OBJECT_SIZE + POINTER_SIZE;
        size += (long)(2 * POINTER_SIZE);
        long dequeNodeSize = this.calculateDequeNodeSize();
        return this.roundUpToNearest8(++size) + dequeNodeSize;
    }

    private long calculateDequeNodeSize() {
        long size = OBJECT_SIZE + POINTER_SIZE;
        return this.roundUpToNearest8(size += (long)(3 * POINTER_SIZE));
    }

    @Override
    public long calculateSize(K key, V value) {
        long result = this.calculator.calculateSize(key, value) + this.nodeAverageSize;
        if (result < 0L) {
            throw new ArithmeticException("Size overflow!");
        }
        return result;
    }
}

