/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.appclient.parser.spec;

import java.util.HashMap;
import java.util.Map;

public enum AppClientElement {
    UNKNOWN(null),
    CALLBACK_HANDLER("callback-handler"),
    MODULE_NAME("module-name"),
    MESSAGE_DESTINATION("message-destination");

    private final String elementName;
    private static final Map<String, AppClientElement> ELEMENT_MAP;

    private AppClientElement(String name) {
        this.elementName = name;
    }

    public String getLocalName() {
        return this.elementName;
    }

    public static AppClientElement forName(String elementName) {
        AppClientElement element = ELEMENT_MAP.get(elementName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, AppClientElement> map = new HashMap<String, AppClientElement>();
        for (AppClientElement element : AppClientElement.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        ELEMENT_MAP = map;
    }
}

