/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.process.ProcessInfo;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.logging.ProcessLogger;
import org.jboss.as.process.protocol.Connection;
import org.jboss.as.process.protocol.MessageHandler;
import org.jboss.as.process.protocol.ProtocolClient;
import org.jboss.as.process.protocol.StreamUtils;
import org.wildfly.common.Assert;

public final class ProcessControllerClient
implements Closeable {
    public static final String HOST_CONTROLLER_PROCESS_NAME = "Host Controller";
    private final Connection connection;

    ProcessControllerClient(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessControllerClient connect(ProtocolClient.Configuration configuration, String authCode, final ProcessMessageHandler messageHandler) throws IOException {
        Assert.checkNotNullParam((String)"configuration", (Object)configuration);
        Assert.checkNotNullParam((String)"authCode", (Object)authCode);
        Assert.checkNotNullParam((String)"messageHandler", (Object)messageHandler);
        configuration.setMessageHandler(new MessageHandler(){

            @Override
            public void handleMessage(Connection connection, InputStream dataStream) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                int cmd = StreamUtils.readUnsignedByte(dataStream);
                switch (cmd) {
                    case 16: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_added for process %s", processName);
                        messageHandler.handleProcessAdded(client, processName);
                        break;
                    }
                    case 17: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_started for process %s", processName);
                        messageHandler.handleProcessStarted(client, processName);
                        break;
                    }
                    case 18: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        long uptimeMillis = StreamUtils.readLong(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_stopped for process %s", processName);
                        messageHandler.handleProcessStopped(client, processName, uptimeMillis);
                        break;
                    }
                    case 19: {
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_removed for process %s", processName);
                        messageHandler.handleProcessRemoved(client, processName);
                        break;
                    }
                    case 20: {
                        int cnt = StreamUtils.readInt(dataStream);
                        HashMap<String, ProcessInfo> inventory = new HashMap<String, ProcessInfo>();
                        for (int i = 0; i < cnt; ++i) {
                            String processName = StreamUtils.readUTFZBytes(dataStream);
                            byte[] processAuthBytes = new byte[24];
                            StreamUtils.readFully(dataStream, processAuthBytes);
                            boolean processRunning = StreamUtils.readBoolean(dataStream);
                            boolean processStopping = StreamUtils.readBoolean(dataStream);
                            String processAuthKey = new String(processAuthBytes, Charset.forName("US-ASCII"));
                            inventory.put(processName, new ProcessInfo(processName, processAuthKey, processRunning, processStopping));
                        }
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received process_inventory", new Object[0]);
                        messageHandler.handleProcessInventory(client, inventory);
                        break;
                    }
                    case 22: {
                        int operationType = StreamUtils.readUnsignedByte(dataStream);
                        ProcessMessageHandler.OperationType type = ProcessMessageHandler.OperationType.fromCode(operationType);
                        String processName = StreamUtils.readUTFZBytes(dataStream);
                        dataStream.close();
                        ProcessLogger.CLIENT_LOGGER.tracef("Received operation_failed for process %s", processName);
                        messageHandler.handleOperationFailed(client, type, processName);
                        break;
                    }
                    default: {
                        ProcessLogger.CLIENT_LOGGER.receivedUnknownMessageCode(cmd);
                        dataStream.close();
                    }
                }
            }

            @Override
            public void handleShutdown(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionShutdown(client);
            }

            @Override
            public void handleFailure(Connection connection, IOException cause) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFailure(client, cause);
            }

            @Override
            public void handleFinished(Connection connection) throws IOException {
                ProcessControllerClient client = (ProcessControllerClient)connection.getAttachment();
                messageHandler.handleConnectionFinished(client);
            }
        });
        ProtocolClient client = new ProtocolClient(configuration);
        Connection connection = client.connect();
        boolean ok = false;
        try {
            ProcessControllerClient processControllerClient;
            OutputStream os = connection.writeMessage();
            try {
                os.write(238);
                os.write(1);
                os.write(authCode.getBytes(Charset.forName("US-ASCII")));
                ProcessControllerClient processControllerClient2 = new ProcessControllerClient(connection);
                connection.attach(processControllerClient2);
                ProcessLogger.CLIENT_LOGGER.trace("Sent initial greeting message");
                os.close();
                ok = true;
                processControllerClient = processControllerClient2;
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(os);
                throw throwable;
            }
            StreamUtils.safeClose(os);
            return processControllerClient;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream sendStdin(String processName) throws IOException {
        OutputStream os = this.connection.writeMessage();
        boolean ok = false;
        try {
            os.write(20);
            StreamUtils.writeUTFZBytes(os, processName);
            ok = true;
            OutputStream outputStream = os;
            return outputStream;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose(os);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(String processName, String authKey, String[] cmd, String workingDir, Map<String, String> env) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        Assert.checkNotNullParam((String)"authKey", (Object)authKey);
        Assert.checkNotNullParam((String)"cmd", (Object)cmd);
        Assert.checkNotNullParam((String)"workingDir", (Object)workingDir);
        Assert.checkNotNullParam((String)"env", env);
        Assert.checkNotEmptyParam((String)"cmd", Arrays.asList(cmd));
        if (authKey.length() != 24) {
            throw ProcessLogger.ROOT_LOGGER.invalidAuthKeyLen();
        }
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(16);
            StreamUtils.writeUTFZBytes(os, processName);
            os.write(authKey.getBytes(Charset.forName("US-ASCII")));
            StreamUtils.writeInt(os, cmd.length);
            for (String c : cmd) {
                StreamUtils.writeUTFZBytes(os, c);
            }
            StreamUtils.writeInt(os, env.size());
            for (String key : env.keySet()) {
                String value = env.get(key);
                StreamUtils.writeUTFZBytes(os, key);
                if (value != null) {
                    StreamUtils.writeUTFZBytes(os, value);
                    continue;
                }
                StreamUtils.writeUTFZBytes(os, "");
            }
            StreamUtils.writeUTFZBytes(os, workingDir);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void startProcess(String processName) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(17);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void stopProcess(String processName) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(18);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void removeProcess(String processName) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(19);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void requestProcessInventory() throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(21);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnectProcess(String processName, URI managementURI, boolean managementSubsystemEndpoint, String authKey) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(22);
            StreamUtils.writeUTFZBytes(os, processName);
            StreamUtils.writeUTFZBytes(os, managementURI.getScheme());
            StreamUtils.writeUTFZBytes(os, managementURI.getHost());
            StreamUtils.writeInt(os, managementURI.getPort());
            StreamUtils.writeBoolean(os, managementSubsystemEndpoint);
            os.write(authKey.getBytes(Charset.forName("US-ASCII")));
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void shutdown() throws IOException {
        this.shutdown(0);
    }

    public void shutdown(int exitCode) throws IOException {
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(23);
            StreamUtils.writeInt(os, exitCode);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void destroyProcess(String processName) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(24);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    public void killProcess(String processName) throws IOException {
        Assert.checkNotNullParam((String)"processName", (Object)processName);
        OutputStream os = this.connection.writeMessage();
        try {
            os.write(25);
            StreamUtils.writeUTFZBytes(os, processName);
            os.close();
        }
        finally {
            StreamUtils.safeClose(os);
        }
    }

    @Override
    public void close() throws IOException {
        this.connection.close();
    }
}

