/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.util.Condition;

public class CondVar {
    protected final Lock lock;
    protected final java.util.concurrent.locks.Condition cond;

    public CondVar() {
        this.lock = new ReentrantLock();
        this.cond = this.lock.newCondition();
    }

    public CondVar(Lock lock) {
        this.lock = lock;
        this.cond = lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(Condition condition) {
        boolean intr = false;
        this.lock.lock();
        try {
            while (!condition.isMet()) {
                try {
                    this.cond.await();
                }
                catch (InterruptedException e) {
                    intr = true;
                }
            }
        }
        finally {
            this.lock.unlock();
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(Condition condition, long timeout, TimeUnit unit) {
        boolean intr = false;
        long timeout_ns = TimeUnit.NANOSECONDS.convert(timeout, unit);
        this.lock.lock();
        try {
            long wait_time = timeout_ns;
            long start = System.nanoTime();
            while (wait_time > 0L && !condition.isMet()) {
                try {
                    wait_time = this.cond.awaitNanos(wait_time);
                }
                catch (InterruptedException e) {
                    wait_time = timeout_ns - (System.nanoTime() - start);
                    intr = true;
                }
            }
            boolean bl = condition.isMet();
            return bl;
        }
        finally {
            this.lock.unlock();
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signal(boolean signal_all) {
        this.lock.lock();
        try {
            if (signal_all) {
                this.cond.signalAll();
            } else {
                this.cond.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

