/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class HasFilterSpec
extends FilterSpec {
    private final String attribute;

    public HasFilterSpec(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        return attributes.containsKey(this.attribute);
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        return attributes.containsKey(this.attribute);
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return attributeNames.contains(this.attribute);
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return !this.mayMatch(attributeNames);
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public String getAttribute() {
        return this.attribute;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(');
        FilterSpec.escapeTo(this.attribute, builder);
        builder.append('=').append('*').append(')');
    }
}

