/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction.client;

import java.security.AccessController;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.resource.spi.XATerminator;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.wildfly.common.Assert;
import org.wildfly.common.annotation.NotNull;
import org.wildfly.common.context.ContextManager;
import org.wildfly.common.context.Contextual;
import org.wildfly.transaction.TransactionPermission;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.ContextXATerminator;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.ImportResult;
import org.wildfly.transaction.client.LocalTransaction;
import org.wildfly.transaction.client.XAImporter;
import org.wildfly.transaction.client.XARecoverable;
import org.wildfly.transaction.client._private.Log;
import org.wildfly.transaction.client.spi.LocalTransactionProvider;

public final class LocalTransactionContext
implements Contextual<LocalTransactionContext> {
    public static final int DEFAULT_TXN_TIMEOUT = 300;
    private static final ContextManager<LocalTransactionContext> CONTEXT_MANAGER = new ContextManager<LocalTransactionContext>(LocalTransactionContext.class, "org.wildfly.transaction.client.context.local");
    private static final Supplier<LocalTransactionContext> PRIVILEGED_SUPPLIER = AccessController.doPrivileged(CONTEXT_MANAGER::getPrivilegedSupplier);
    private static final Object LOCAL_TXN_KEY = new Object();
    private static final TransactionPermission CREATION_LISTENER_PERMISSION = TransactionPermission.forName("registerCreationListener");
    private static final TransactionPermission SUSPEND_REQUESTS_PERMISSION = TransactionPermission.forName("suspendRequests");
    private static final TransactionPermission RESUME_REQUESTS_PERMISSION = TransactionPermission.forName("resumeRequests");
    private static final TransactionPermission GET_XA_TERMINATOR_PERMISSION = TransactionPermission.forName("getXATerminator");
    private static final TransactionPermission GET_RECOVERY_INTERFACE_PERMISSION = TransactionPermission.forName("getRecoveryInterface");
    private final LocalTransactionProvider provider;
    private final XATerminator xaTerminator = new ContextXATerminator(this);
    private final List<CreationListener> creationListeners = new CopyOnWriteArrayList<CreationListener>();
    private volatile boolean requestsSuspended;

    public LocalTransactionContext(LocalTransactionProvider provider) {
        Assert.checkNotNullParam("provider", provider);
        this.provider = provider;
    }

    @NotNull
    public static ContextManager<LocalTransactionContext> getContextManager() {
        return CONTEXT_MANAGER;
    }

    @Override
    @NotNull
    public ContextManager<LocalTransactionContext> getInstanceContextManager() {
        return LocalTransactionContext.getContextManager();
    }

    @NotNull
    public static LocalTransactionContext getCurrent() {
        return PRIVILEGED_SUPPLIER.get();
    }

    private LocalTransaction notifyCreationListeners(LocalTransaction transaction, CreationListener.CreatedBy createdBy) {
        for (CreationListener creationListener : this.creationListeners) {
            try {
                creationListener.transactionCreated(transaction, createdBy);
            }
            catch (Throwable t) {
                Log.log.trace("Transaction creation listener throws an exception", t);
            }
        }
        return transaction;
    }

    public void registerCreationListener(CreationListener creationListener) {
        Assert.checkNotNullParam("creationListener", creationListener);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATION_LISTENER_PERMISSION);
        }
        this.creationListeners.add(creationListener);
    }

    public void removeCreationListener(CreationListener creationListener) {
        Assert.checkNotNullParam("creationListener", creationListener);
        this.creationListeners.removeIf(c -> c == creationListener);
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout) throws SystemException, SecurityException {
        return this.beginTransaction(timeout, false);
    }

    @NotNull
    public LocalTransaction beginTransaction(int timeout, boolean failOnSuspend) throws SystemException, SecurityException {
        return this.beginTransaction(timeout, failOnSuspend, CreationListener.CreatedBy.TRANSACTION_MANAGER);
    }

    @NotNull
    LocalTransaction beginTransaction(int timeout, boolean failOnSuspend, CreationListener.CreatedBy createdBy) throws SystemException, SecurityException {
        Assert.checkMinimumParameter("timeout", 0, timeout);
        if (failOnSuspend && this.requestsSuspended) {
            throw Log.log.suspendedCannotCreateNew();
        }
        Transaction newTransaction = this.provider.createNewTransaction(timeout);
        if (newTransaction == null) {
            throw Log.log.providerCreatedNullTransaction();
        }
        return this.getOrAttach(newTransaction, createdBy);
    }

    public ImportResult<LocalTransaction> findOrImportTransaction(Xid xid, int timeout, boolean doNotImport) throws XAException {
        Assert.checkNotNullParam("xid", xid);
        Assert.checkMinimumParameter("timeout", 0, timeout);
        XAImporter xaImporter = this.provider.getXAImporter();
        boolean requestsSuspended = this.requestsSuspended;
        ImportResult<?> result = xaImporter.findOrImportTransaction(xid, timeout, doNotImport || requestsSuspended);
        if (result == null) {
            if (!doNotImport) {
                if (requestsSuspended) {
                    throw Log.log.suspendedCannotImportXa(-3);
                }
                throw Log.log.providerCreatedNullTransaction();
            }
            return null;
        }
        return result.withTransaction(this.getOrAttach((Transaction)result.getTransaction(), result.isNew() ? CreationListener.CreatedBy.IMPORT : CreationListener.CreatedBy.MERGE));
    }

    @NotNull
    public ImportResult<LocalTransaction> findOrImportTransaction(Xid xid, int timeout) throws XAException {
        return Assert.assertNotNull(this.findOrImportTransaction(xid, timeout, false));
    }

    public boolean importProviderTransaction() throws SystemException {
        ContextTransactionManager.State state = ContextTransactionManager.INSTANCE.getStateRef().get();
        Transaction transaction = this.provider.getTransactionManager().getTransaction();
        if (transaction == null) {
            return false;
        }
        LocalTransaction localTransaction = this.getOrAttach(transaction, CreationListener.CreatedBy.MERGE);
        if (state.transaction == null) {
            state.transaction = localTransaction;
        } else {
            localTransaction.verifyAssociation();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalTransaction getOrAttach(Transaction transaction, CreationListener.CreatedBy createdBy) {
        LocalTransaction txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
        boolean isNew = false;
        if (txn == null) {
            Object object = LOCAL_TXN_KEY;
            synchronized (object) {
                txn = (LocalTransaction)this.provider.getResource(transaction, LOCAL_TXN_KEY);
                if (txn == null) {
                    txn = new LocalTransaction(this, transaction);
                    this.provider.putResource(transaction, LOCAL_TXN_KEY, txn);
                    isNew = true;
                }
            }
        }
        if (isNew) {
            this.notifyCreationListeners(txn, createdBy);
        }
        return txn;
    }

    @NotNull
    public XARecoverable getRecoveryInterface() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_RECOVERY_INTERFACE_PERMISSION);
        }
        final XAImporter xaImporter = this.provider.getXAImporter();
        return new XARecoverable(){

            @Override
            public Xid[] recover(int flag, String parentName) throws XAException {
                return xaImporter.recover(flag, parentName);
            }

            @Override
            public void commit(Xid xid, boolean onePhase) throws XAException {
                xaImporter.commit(xid, onePhase);
            }

            @Override
            public void forget(Xid xid) throws XAException {
                xaImporter.forget(xid);
            }
        };
    }

    @NotNull
    public XATerminator getXATerminator() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_XA_TERMINATOR_PERMISSION);
        }
        return this.xaTerminator;
    }

    public void suspendRequests() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUSPEND_REQUESTS_PERMISSION);
        }
        this.requestsSuspended = true;
    }

    public void resumeRequests() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(RESUME_REQUESTS_PERMISSION);
        }
        this.requestsSuspended = false;
    }

    LocalTransactionProvider getProvider() {
        return this.provider;
    }

    public String toString() {
        return String.format("Local transaction context for provider %s", this.provider);
    }

    static {
        AccessController.doPrivileged(() -> {
            CONTEXT_MANAGER.setGlobalDefault(new LocalTransactionContext(LocalTransactionProvider.EMPTY));
            return null;
        });
    }
}

