/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.txframework.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.narayana.txframework.api.annotation.lifecycle.ba.ConfirmCompleted;
import org.jboss.narayana.txframework.impl.ServiceInvocationMeta;
import org.jboss.narayana.txframework.impl.TXDataMapImpl;
import org.jboss.narayana.txframework.impl.handlers.ParticipantRegistrationException;

public abstract class Participant {
    protected ServiceInvocationMeta serviceInvocationMeta;
    protected Map<Class<? extends Annotation>, Method> lifecycleEventMap = new HashMap<Class<? extends Annotation>, Method>();
    protected List<Method> visibleMethods;
    private Map txDataMap;

    public Participant(ServiceInvocationMeta serviceInvocationMeta, Map txDataMap) throws ParticipantRegistrationException {
        this.serviceInvocationMeta = serviceInvocationMeta;
        this.visibleMethods = this.getAllVisibleMethods(serviceInvocationMeta.getServiceClass());
        this.txDataMap = txDataMap;
    }

    public void resume() {
        TXDataMapImpl.resume(this.txDataMap);
    }

    public static void suspend() {
        TXDataMapImpl.suspend();
    }

    protected void registerEventsOfInterest(Class<? extends Annotation> ... lifecycleEvents) {
        for (Class<? extends Annotation> lifecycleEvent : lifecycleEvents) {
            for (Method method : this.visibleMethods) {
                Annotation annotation = method.getAnnotation(lifecycleEvent);
                if (annotation == null) continue;
                this.lifecycleEventMap.put(lifecycleEvent, method);
            }
        }
    }

    protected Object invoke(Class<? extends Annotation> lifecycleEvent, Object ... args) {
        this.resume();
        Method method = this.lifecycleEventMap.get(lifecycleEvent);
        if (method == null) {
            return null;
        }
        try {
            method.setAccessible(true);
            if (lifecycleEvent == ConfirmCompleted.class) {
                Object object = method.invoke(this.serviceInvocationMeta.getProxyInstance(), args);
                return object;
            }
            Object object = method.invoke(this.serviceInvocationMeta.getProxyInstance(), new Object[0]);
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to invoke method '" + method.getName() + "' on '" + this.serviceInvocationMeta.getServiceClass().getName() + "'", e);
        }
        finally {
            Participant.suspend();
        }
    }

    private List<Method> getAllVisibleMethods(Class clazz) {
        Method[] methods = clazz.getMethods();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        LinkedList<Method> results = new LinkedList<Method>();
        for (Method m : methods) {
            if (results.contains(m)) continue;
            results.add(m);
        }
        for (Method m : declaredMethods) {
            if (results.contains(m)) continue;
            results.add(m);
        }
        return results;
    }
}

