/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.spi;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import org.jberet._private.BatchMessages;
import org.jberet.spi.JobTask;

public abstract class JobExecutor
implements Executor {
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Executor delegate;
    private final Deque<JobTask> queuedTasks;
    private int usedPermits;

    protected JobExecutor(Executor delegate) {
        this.delegate = delegate;
        this.queuedTasks = new ArrayDeque<JobTask>();
        this.usedPermits = 0;
    }

    protected abstract int getMaximumPoolSize();

    @Override
    public final void execute(Runnable runnable) {
        this.execute(this.wrap(runnable), false);
    }

    public final void execute(JobTask task) {
        this.execute(task, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(final JobTask task, boolean reentry) {
        int requiredRemainingPermits = task.getRequiredRemainingPermits() < 0 ? 0 : task.getRequiredRemainingPermits();
        Runnable r = null;
        int maxPermits = this.getMaximumPoolSize();
        if (requiredRemainingPermits > maxPermits) {
            throw BatchMessages.MESSAGES.insufficientPermits(requiredRemainingPermits, maxPermits);
        }
        this.lock.lock();
        try {
            if (this.usedPermits + requiredRemainingPermits <= maxPermits) {
                ++this.usedPermits;
                r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.run();
                        }
                        finally {
                            JobExecutor.this.release();
                        }
                    }
                };
            } else if (requiredRemainingPermits == 0) {
                ++this.usedPermits;
                r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            task.run();
                        }
                        finally {
                            JobExecutor.this.release();
                        }
                    }
                };
            } else if (reentry) {
                this.queuedTasks.addFirst(task);
            } else {
                this.queuedTasks.add(task);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (r != null) {
            this.delegate.execute(r);
        }
    }

    private void release() {
        JobTask next;
        this.lock.lock();
        try {
            --this.usedPermits;
            if (this.usedPermits < 0) {
                this.usedPermits = 0;
            }
            next = this.queuedTasks.poll();
        }
        finally {
            this.lock.unlock();
        }
        if (next != null) {
            this.execute(next, true);
        }
    }

    private JobTask wrap(final Runnable task) {
        if (task instanceof JobTask) {
            return (JobTask)task;
        }
        return new JobTask(){

            @Override
            public int getRequiredRemainingPermits() {
                return 0;
            }

            @Override
            public void run() {
                task.run();
            }
        };
    }
}

