/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.jdbc;

import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.security.auth.realm.jdbc.JdbcSecurityRealm;
import org.wildfly.security.auth.realm.jdbc.QueryBuilder;
import org.wildfly.security.auth.realm.jdbc.QueryConfiguration;

public class JdbcSecurityRealmBuilder {
    private Supplier<Provider[]> providers = Security::getProviders;
    private List<QueryBuilder> queries = new ArrayList<QueryBuilder>();

    JdbcSecurityRealmBuilder() {
    }

    public JdbcSecurityRealm build() {
        ArrayList<QueryConfiguration> configuration = new ArrayList<QueryConfiguration>();
        for (QueryBuilder query : this.queries) {
            configuration.add(query.buildQuery());
        }
        return new JdbcSecurityRealm(configuration, this.providers);
    }

    public JdbcSecurityRealmBuilder setProviders(Supplier<Provider[]> providers) {
        this.providers = providers;
        return this;
    }

    public QueryBuilder principalQuery(String sql) {
        QueryBuilder builder = new QueryBuilder(sql, this);
        this.queries.add(builder);
        return builder;
    }
}

