/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.LayerType;
import org.jboss.as.patching.metadata.Patch;
import org.jboss.as.patching.metadata.PatchElementProvider;
import org.jboss.as.patching.metadata.impl.IncompatibleWithCallback;
import org.jboss.as.patching.metadata.impl.RequiresCallback;

public class PatchElementProviderImpl
implements PatchElementProvider,
RequiresCallback,
IncompatibleWithCallback {
    private final String name;
    private final boolean isAddOn;
    private Patch.PatchType patchType;
    private Collection<String> incompatibleWith = Collections.emptyList();
    private Collection<String> requires = Collections.emptyList();

    public PatchElementProviderImpl(String name, boolean isAddOn) {
        assert (name != null);
        this.name = name;
        this.isAddOn = isAddOn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Patch.PatchType getPatchType() {
        return this.patchType;
    }

    @Override
    public Collection<String> getRequires() {
        return this.requires;
    }

    @Override
    public Collection<String> getIncompatibleWith() {
        return this.incompatibleWith;
    }

    @Override
    public boolean isAddOn() {
        return this.isAddOn;
    }

    @Override
    public LayerType getLayerType() {
        return this.isAddOn ? LayerType.AddOn : LayerType.Layer;
    }

    public void upgrade() {
        this.patchType = Patch.PatchType.CUMULATIVE;
    }

    public void oneOffPatch() {
        this.patchType = Patch.PatchType.ONE_OFF;
    }

    @Override
    public PatchElementProviderImpl incompatibleWith(String patchID) {
        assert (patchID != null);
        if (this.incompatibleWith.isEmpty()) {
            this.incompatibleWith = new ArrayList<String>();
        }
        this.incompatibleWith.add(patchID);
        return this;
    }

    @Override
    public PatchElementProviderImpl require(String elementId) {
        if (this.requires.isEmpty()) {
            this.requires = new ArrayList<String>();
        }
        this.requires.add(elementId);
        return this;
    }

    @Override
    public <T extends PatchElementProvider> T forType(Patch.PatchType patchType, Class<T> clazz) {
        if (patchType != this.patchType) {
            throw PatchLogger.ROOT_LOGGER.patchTypesDontMatch();
        }
        return (T)((PatchElementProvider)clazz.cast(this));
    }
}

