/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.service.ConfigService;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

final class EndpointConfigAdd
extends AbstractAddStepHandler {
    static final EndpointConfigAdd INSTANCE = new EndpointConfigAdd();

    private EndpointConfigAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            ServerConfig serverConfig = ASHelper.getMSCService(WSServices.CONFIG_SERVICE, ServerConfig.class, context);
            if (serverConfig == null) {
                throw WSLogger.ROOT_LOGGER.serviceNotAvailable(WSServices.CONFIG_SERVICE.getCanonicalName());
            }
            ServiceName serviceName = PackageUtils.getEndpointConfigServiceName(name);
            ConfigService endpointConfigService = new ConfigService(serverConfig, name, false);
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder serviceBuilder = target.addService(serviceName, (Service)endpointConfigService);
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "property")) {
                serviceBuilder.addDependency(sn, PropertyService.class, endpointConfigService.getPropertiesInjector());
            }
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "pre-handler-chain")) {
                serviceBuilder.addDependency(sn, UnifiedHandlerChainMetaData.class, endpointConfigService.getPreHandlerChainsInjector());
            }
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, serviceName, address, "post-handler-chain")) {
                serviceBuilder.addDependency(sn, UnifiedHandlerChainMetaData.class, endpointConfigService.getPostHandlerChainsInjector());
            }
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        } else {
            context.reloadRequired();
        }
    }
}

