/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.List;
import java.util.Map;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.web.host.WebHost;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.publish.EndpointPublisherHelper;
import org.jboss.as.webservices.service.EndpointDeployService;
import org.jboss.as.webservices.service.EndpointService;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.wsf.spi.metadata.webservices.JBossWebservicesMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;
import org.jboss.wsf.spi.publish.Context;

public final class EndpointPublishService
implements Service<Context> {
    private final ServiceName name;
    private volatile Context wsctx;
    private final DeploymentUnit deploymentUnit;
    private final InjectedValue<WebHost> hostInjector = new InjectedValue();

    private EndpointPublishService(String context, DeploymentUnit deploymentUnit) {
        this.name = WSServices.ENDPOINT_PUBLISH_SERVICE.append(new String[]{context});
        this.deploymentUnit = deploymentUnit;
    }

    public Context getValue() {
        return this.wsctx;
    }

    public ServiceName getName() {
        return this.name;
    }

    public InjectedValue<WebHost> getHostInjector() {
        return this.hostInjector;
    }

    public void start(StartContext ctx) throws StartException {
        WSLogger.ROOT_LOGGER.starting(this.name);
        try {
            this.wsctx = EndpointPublisherHelper.doPublishStep((WebHost)this.hostInjector.getValue(), ctx.getChildTarget(), this.deploymentUnit);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext ctx) {
        WSLogger.ROOT_LOGGER.stopping(this.name);
        List eps = this.wsctx.getEndpoints();
        if (eps == null || eps.isEmpty()) {
            return;
        }
        try {
            EndpointPublisherHelper.undoPublishStep((WebHost)this.hostInjector.getValue(), this.wsctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ServiceBuilder<Context> createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName) {
        return EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, null, null, null);
    }

    public static ServiceBuilder<Context> createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        return EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd, null);
    }

    public static ServiceBuilder<Context> createServiceBuilder(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd, Map<Class<?>, Object> deploymentAttachments) {
        DeploymentUnit unit = EndpointDeployService.install(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd, deploymentAttachments);
        EndpointPublishService service = new EndpointPublishService(context, unit);
        ServiceBuilder builder = serviceTarget.addService(service.getName(), (Service)service);
        builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, WSServices.CONFIG_SERVICE);
        builder.addDependency(WebHost.SERVICE_NAME.append(new String[]{hostName}), WebHost.class, service.getHostInjector());
        for (ServiceName epServiceName : EndpointService.getServiceNamesFromDeploymentUnit(unit)) {
            builder.addDependency(ServiceBuilder.DependencyType.REQUIRED, epServiceName);
        }
        return builder;
    }

    public static void install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName) {
        EndpointPublishService.install(serviceTarget, context, loader, hostName, urlPatternToClassName, null, null, null);
    }

    public static void install(ServiceTarget serviceTarget, String context, ClassLoader loader, String hostName, Map<String, String> urlPatternToClassName, JBossWebMetaData jbwmd, WebservicesMetaData wsmd, JBossWebservicesMetaData jbwsmd) {
        ServiceBuilder<Context> builder = EndpointPublishService.createServiceBuilder(serviceTarget, context, loader, hostName, urlPatternToClassName, jbwmd, wsmd, jbwsmd);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        builder.install();
    }
}

