/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.elytron._private.ElytronSubsystemMessages;

final class ServiceUtil<T> {
    private final RuntimeCapability<?> runtimeCapability;
    private final String key;
    private final Class<T> clazz;

    private ServiceUtil(RuntimeCapability<?> runtimeCapability, String key, Class<T> injectionClass) {
        this.runtimeCapability = runtimeCapability;
        this.key = key;
        this.clazz = injectionClass;
    }

    ServiceName serviceName(String name) {
        RuntimeCapability dynamicCapability = this.runtimeCapability.fromBaseCapability(name);
        return dynamicCapability.getCapabilityServiceName(this.clazz);
    }

    ServiceName serviceName(ModelNode operation) {
        String name = null;
        PathAddress pa = PathAddress.pathAddress((ModelNode)operation.require("address"));
        for (int i = pa.size() - 1; i > 0; --i) {
            PathElement pe = pa.getElement(i);
            if (!this.key.equals(pe.getKey())) continue;
            name = pe.getValue();
            break;
        }
        if (name == null) {
            throw ElytronSubsystemMessages.ROOT_LOGGER.operationAddressMissingKey(this.key);
        }
        return this.serviceName(name);
    }

    ServiceBuilder<?> addInjection(ServiceBuilder<?> sb, Injector<T> injector, String name) {
        return this.addInjection(sb, injector, this.serviceName(name));
    }

    ServiceBuilder<?> addInjection(ServiceBuilder<?> sb, Injector<T> injector, ServiceName serviceName) {
        sb.addDependency(ServiceBuilder.DependencyType.REQUIRED, serviceName, this.clazz, injector);
        return sb;
    }

    public static <T> ServiceUtil<T> newInstance(RuntimeCapability<?> runtimeCapability, String key, Class<T> injectionClass) {
        return new ServiceUtil<T>(runtimeCapability, key, injectionClass);
    }
}

