/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import javax.jms.Connection;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.QueueConnection;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.XAConnection;
import javax.jms.XAJMSContext;
import javax.jms.XAQueueConnection;
import javax.jms.XATopicConnection;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.referenceable.ConnectionFactoryObjectFactory;
import org.apache.activemq.artemis.jms.referenceable.SerializableObjectRefAddr;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRAConnectionManager;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRAManagedConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQRASessionFactoryImpl;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;

public class ActiveMQRAConnectionFactoryImpl
implements ActiveMQRAConnectionFactory {
    static final long serialVersionUID = 7981708919479859360L;
    private static boolean trace = ActiveMQRALogger.LOGGER.isTraceEnabled();
    private final ActiveMQRAManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private Reference reference;

    public ActiveMQRAConnectionFactoryImpl(ActiveMQRAManagedConnectionFactory mcf, ConnectionManager cm) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + mcf + ", " + cm + ")");
        }
        this.mcf = mcf;
        if (cm == null) {
            this.cm = new ActiveMQRAConnectionManager();
            if (trace) {
                ActiveMQRALogger.LOGGER.trace("Created new ConnectionManager=" + this.cm);
            }
        } else {
            this.cm = cm;
        }
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Using ManagedConnectionFactory=" + mcf + ", ConnectionManager=" + cm);
        }
    }

    public void setReference(Reference reference) {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("setReference(" + reference + ")");
        }
        this.reference = reference;
    }

    public Reference getReference() {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("getReference()");
        }
        if (this.reference == null) {
            try {
                this.reference = new Reference(this.getClass().getCanonicalName(), (RefAddr)new SerializableObjectRefAddr("ActiveMQ-CF", (Object)this), ConnectionFactoryObjectFactory.class.getCanonicalName(), null);
            }
            catch (NamingException e) {
                ActiveMQRALogger.LOGGER.errorCreatingReference(e);
            }
        }
        return this.reference;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createQueueConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 1);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createQueueConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 1);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createTopicConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 2);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createTopicConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 2);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public Connection createConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXAQueueConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 4);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public XAQueueConnection createXAQueueConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXAQueueConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 4);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created queue connection: " + s);
        }
        return s;
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXATopicConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 5);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public XATopicConnection createXATopicConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXATopicConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 5);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created topic connection: " + s);
        }
        return s;
    }

    public XAConnection createXAConnection() throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXAConnection()");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("createXAConnection(" + userName + ", ****)");
        }
        ActiveMQRASessionFactoryImpl s = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        s.setUserName(userName);
        s.setPassword(password);
        this.validateUser(s);
        if (trace) {
            ActiveMQRALogger.LOGGER.trace("Created connection: " + s);
        }
        return s;
    }

    public JMSContext createContext() {
        return this.createContext(null, null);
    }

    public JMSContext createContext(String userName, String password) {
        return this.createContext(userName, password, 1);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        ActiveMQRASessionFactoryImpl conn = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 0);
        conn.setUserName(userName);
        conn.setPassword(password);
        try {
            this.validateUser(conn);
        }
        catch (JMSSecurityException e) {
            JMSSecurityRuntimeException e2 = new JMSSecurityRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return conn.createContext(sessionMode);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public XAJMSContext createXAContext() {
        return this.createXAContext(null, null);
    }

    public XAJMSContext createXAContext(String userName, String password) {
        ActiveMQRASessionFactoryImpl conn = new ActiveMQRASessionFactoryImpl(this.mcf, this.cm, this.getResourceAdapter().getTM(), 3);
        conn.setUserName(userName);
        conn.setPassword(password);
        try {
            this.validateUser(conn);
        }
        catch (JMSSecurityException e) {
            JMSSecurityRuntimeException e2 = new JMSSecurityRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (JMSException e) {
            JMSRuntimeException e2 = new JMSRuntimeException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        return conn.createXAContext();
    }

    private void validateUser(ActiveMQRASessionFactoryImpl s) throws JMSException {
        Session session = s.createSession();
        session.close();
    }

    @Override
    public ActiveMQConnectionFactory getDefaultFactory() throws ResourceException {
        return ((ActiveMQResourceAdapter)this.mcf.getResourceAdapter()).getDefaultActiveMQConnectionFactory();
    }

    @Override
    public ActiveMQResourceAdapter getResourceAdapter() {
        return (ActiveMQResourceAdapter)this.mcf.getResourceAdapter();
    }
}

