/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.jgroups.spi.JGroupsDefaultRequirement;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.DiscoveryGroupDefinition;

public class DiscoveryGroupRemove
extends AbstractRemoveStepHandler {
    public static final DiscoveryGroupRemove INSTANCE = new DiscoveryGroupRemove();

    private DiscoveryGroupRemove() {
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        String discoveryGroupName = context.getCurrentAddressValue();
        String serverName = context.getCurrentAddress().getParent().getLastElement().getValue();
        String compositeName = serverName + "." + discoveryGroupName;
        context.deregisterCapability(DiscoveryGroupDefinition.CHANNEL_FACTORY_CAPABILITY.getDynamicName(compositeName));
        ModelNode model = resource.getModel();
        if (CommonAttributes.JGROUPS_CHANNEL.resolveModelAttribute(context, model).isDefined() && !DiscoveryGroupDefinition.JGROUPS_STACK.resolveModelAttribute(context, model).isDefined()) {
            context.deregisterCapabilityRequirement(JGroupsDefaultRequirement.CHANNEL_FACTORY.getName(), RuntimeCapability.buildDynamicCapabilityName((String)DiscoveryGroupDefinition.CHANNEL_FACTORY_CAPABILITY.getName(), (String)compositeName));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.reloadRequired();
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        context.revertReloadRequired();
    }
}

