/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.Map;
import java.util.Set;
import javax.xml.ws.Dispatch;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxws.DispatchImpl;
import org.jboss.ws.api.util.ServiceLoader;
import org.jboss.ws.common.configuration.ConfigHelper;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.security.JASPIAuthenticationProvider;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.client.configuration.FeatureUtils;
import org.jboss.wsf.stack.cxf.client.configuration.InterceptorUtils;

public class CXFClientConfigurer
extends ConfigHelper {
    private static final String JBOSSWS_CXF_CLIENT_CONF_PROPS = "jbossws.cxf.client.conf.props";

    public void setConfigProperties(Object client, String configFile, String configName) {
        Class<?> clazz = !(client instanceof Dispatch) ? client.getClass() : null;
        ClientConfig config = this.readConfig(configFile, configName, clazz);
        this.setConfigProperties(client, config);
    }

    protected void setConfigProperties(Object client, ClientConfig config) {
        Client cxfClient = client instanceof DispatchImpl ? ((DispatchImpl)client).getClient() : ClientProxy.getClient((Object)client);
        this.cleanupPreviousProps(cxfClient);
        Map props = config.getProperties();
        if (props != null && !props.isEmpty()) {
            this.savePropList(cxfClient, props);
        }
        this.setConfigProperties(cxfClient, props);
        JASPIAuthenticationProvider japsiProvider = (JASPIAuthenticationProvider)ServiceLoader.loadService((String)JASPIAuthenticationProvider.class.getName(), null, (ClassLoader)ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
        if (japsiProvider != null) {
            japsiProvider.enableClientAuthentication((Object)cxfClient, props);
        } else {
            Loggers.SECURITY_LOGGER.cannotFindJaspiClasses();
        }
    }

    public void setConfigProperties(Client client, Map<String, String> properties) {
        client.getEndpoint().putAll(properties);
        InterceptorUtils.addInterceptors((InterceptorProvider)client, properties);
        FeatureUtils.addFeatures((InterceptorProvider)client, client.getBus(), properties);
    }

    private void savePropList(Client client, Map<String, String> props) {
        Set<String> keys = props.keySet();
        client.getEndpoint().put((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS, (Object)keys.toArray(new String[keys.size()]));
    }

    private void cleanupPreviousProps(Client client) {
        Endpoint ep = client.getEndpoint();
        String[] previousProps = (String[])ep.get((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        if (previousProps != null) {
            for (String p : previousProps) {
                if ("cxf.interceptors.in".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getInInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.interceptors.out".equals(p)) {
                    InterceptorUtils.removeInterceptors(client.getOutInterceptors(), (String)ep.get((Object)p));
                } else if ("cxf.features".equals(p)) {
                    Loggers.ROOT_LOGGER.couldNoRemoveFeaturesOnClient((String)ep.get((Object)p));
                }
                ep.remove((Object)p);
            }
            ep.remove((Object)JBOSSWS_CXF_CLIENT_CONF_PROPS);
        }
    }
}

