/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.jboss.wsf.stack.cxf.client.configuration.MapToBeanConverter;

public class InterceptorUtils {
    public static void addInterceptors(InterceptorProvider interceptorProvider, Map<String, String> properties) {
        String outInterceptors;
        MapToBeanConverter converter = null;
        String inInterceptors = properties.get("cxf.interceptors.in");
        if (inInterceptors != null) {
            if (converter == null) {
                converter = new MapToBeanConverter(properties);
            }
            interceptorProvider.getInInterceptors().addAll(InterceptorUtils.createInterceptors(inInterceptors, converter));
        }
        if ((outInterceptors = properties.get("cxf.interceptors.out")) != null) {
            if (converter == null) {
                converter = new MapToBeanConverter(properties);
            }
            interceptorProvider.getOutInterceptors().addAll(InterceptorUtils.createInterceptors(outInterceptors, converter));
        }
    }

    public static void removeInterceptors(List<Interceptor<?>> interceptorsList, String interceptors) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(interceptors, ", ", false);
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        ArrayList toBeRemoved = new ArrayList();
        for (Interceptor interceptor : interceptorsList) {
            if (!set.contains(interceptor.getClass().getName())) continue;
            toBeRemoved.add(interceptor);
        }
        interceptorsList.removeAll(toBeRemoved);
    }

    private static List<Interceptor<?>> createInterceptors(String propValue, MapToBeanConverter converter) {
        ArrayList list = new ArrayList();
        StringTokenizer st = new StringTokenizer(propValue, ", ", false);
        while (st.hasMoreTokens()) {
            Interceptor interceptor = (Interceptor)InterceptorUtils.newInstance(st.nextToken(), converter);
            if (interceptor == null) continue;
            list.add(interceptor);
        }
        return list;
    }

    private static Object newInstance(String className, MapToBeanConverter converter) {
        try {
            return className.startsWith("##") ? converter.get(className) : converter.newInstance(className);
        }
        catch (Exception e) {
            return null;
        }
    }
}

