/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiName;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.server.CacheCapabilityServiceBuilderFactory;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.spi.CacheBuilderProvider;
import org.wildfly.clustering.spi.ClusteringCacheRequirement;
import org.wildfly.clustering.spi.ServiceNameRegistry;

public class CacheRequirementBuilderProvider<T>
implements CacheBuilderProvider {
    private final ClusteringCacheRequirement requirement;
    private final CacheCapabilityServiceBuilderFactory<T> factory;
    private final BiFunction<String, String, JndiName> jndiNameFactory;

    protected CacheRequirementBuilderProvider(ClusteringCacheRequirement requirement, CacheCapabilityServiceBuilderFactory<T> factory) {
        this(requirement, factory, null);
    }

    protected CacheRequirementBuilderProvider(ClusteringCacheRequirement requirement, CacheCapabilityServiceBuilderFactory<T> factory, BiFunction<String, String, JndiName> jndiNameFactory) {
        this.requirement = requirement;
        this.factory = factory;
        this.jndiNameFactory = jndiNameFactory;
    }

    public Collection<CapabilityServiceBuilder<?>> getBuilders(ServiceNameRegistry<ClusteringCacheRequirement> registry, String containerName, String cacheName) {
        ServiceName name = registry.getServiceName((Requirement)this.requirement);
        CapabilityServiceBuilder<T> builder = this.factory.createBuilder(name, containerName, cacheName);
        if (this.jndiNameFactory == null) {
            return Collections.singleton(builder);
        }
        ContextNames.BindInfo binding = ContextNames.bindInfoFor((String)this.jndiNameFactory.apply(containerName, cacheName).getAbsoluteName());
        BinderServiceBuilder binderBuilder = new BinderServiceBuilder(binding, builder.getServiceName(), this.requirement.getType());
        return Arrays.asList(builder, binderBuilder);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

