/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.hornetq;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalEnvironmentBean;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;

public class HornetqJournalStore {
    private final Journal journal;
    private final ConcurrentMap<String, ConcurrentMap<Uid, RecordInfo>> content = new ConcurrentHashMap<String, ConcurrentMap<Uid, RecordInfo>>();
    private final boolean syncWrites;
    private final boolean syncDeletes;
    private final AtomicLong maxID = new AtomicLong(0L);
    private final String storeDirCanonicalPath;
    private static final byte RECORD_TYPE = 0;

    public void stop() throws Exception {
        this.journal.stop();
    }

    public void start() throws Exception {
        this.journal.start();
        LinkedList committedRecords = new LinkedList();
        LinkedList preparedTransactions = new LinkedList();
        TransactionFailureCallback failureCallback = new TransactionFailureCallback(){

            public void failedTransaction(long l, List<RecordInfo> recordInfos, List<RecordInfo> recordInfos1) {
                tsLogger.i18NLogger.warn_journal_load_error();
            }
        };
        JournalLoadInformation journalLoadInformation = this.journal.load(committedRecords, preparedTransactions, failureCallback);
        this.maxID.set(journalLoadInformation.getMaxID());
        if (!preparedTransactions.isEmpty()) {
            tsLogger.i18NLogger.warn_journal_load_error();
        }
        for (RecordInfo record : committedRecords) {
            InputBuffer inputBuffer = new InputBuffer(record.data);
            Uid uid = UidHelper.unpackFrom(inputBuffer);
            String typeName = inputBuffer.unpackString();
            this.getContentForType(typeName).put(uid, record);
        }
    }

    public HornetqJournalStore(HornetqJournalEnvironmentBean envBean) throws IOException {
        this.syncWrites = envBean.isSyncWrites();
        this.syncDeletes = envBean.isSyncDeletes();
        File storeDir = new File(envBean.getStoreDir());
        if (!storeDir.exists() && !storeDir.mkdirs()) {
            throw new IOException(tsLogger.i18NLogger.get_dir_create_failed(storeDir.getCanonicalPath()));
        }
        this.storeDirCanonicalPath = storeDir.getCanonicalPath();
        Object sequentialFileFactory = envBean.isAsyncIO() && AIOSequentialFileFactory.isSupported() ? new AIOSequentialFileFactory(storeDir, envBean.getBufferSize(), (int)(1.0E9 / (double)envBean.getBufferFlushesPerSecond()), envBean.getMaxIO(), envBean.isLogRates()) : new NIOSequentialFileFactory(storeDir, true, envBean.getBufferSize(), (int)(1.0E9 / (double)envBean.getBufferFlushesPerSecond()), envBean.getMaxIO(), envBean.isLogRates());
        this.journal = new JournalImpl(envBean.getFileSize(), envBean.getMinFiles(), envBean.getPoolSize(), envBean.getCompactMinFiles(), envBean.getCompactPercentage(), (SequentialFileFactory)sequentialFileFactory, envBean.getFilePrefix(), envBean.getFileExtension(), envBean.getMaxIO());
    }

    public boolean remove_committed(Uid uid, String typeName) throws ObjectStoreException {
        try {
            RecordInfo record = (RecordInfo)this.getContentForType(typeName).remove(uid);
            long id = record != null ? record.id : this.getId(uid, typeName);
            this.journal.appendDeleteRecord(id, this.syncDeletes);
            return true;
        }
        catch (IllegalStateException e) {
            tsLogger.i18NLogger.warn_hornetqobjectstore_remove_state_exception(e);
            return false;
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    public boolean write_committed(Uid uid, String typeName, OutputObjectState txData) throws ObjectStoreException {
        RecordInfo previousRecord = null;
        try {
            OutputBuffer outputBuffer = new OutputBuffer();
            UidHelper.packInto(uid, outputBuffer);
            outputBuffer.packString(typeName);
            outputBuffer.packBytes(txData.buffer());
            byte[] data = outputBuffer.buffer();
            RecordInfo record = new RecordInfo(this.getId(uid, typeName), 0, data, false, 0);
            previousRecord = this.getContentForType(typeName).putIfAbsent(uid, record);
            if (previousRecord != null) {
                this.getContentForType(typeName).replace(uid, record);
                this.journal.appendUpdateRecord(previousRecord.id, (byte)0, data, this.syncWrites);
            } else {
                this.journal.appendAddRecord(record.id, (byte)0, data, this.syncWrites);
            }
        }
        catch (Exception e) {
            if (previousRecord == null) {
                this.getContentForType(typeName).remove(uid);
            }
            throw new ObjectStoreException(e);
        }
        return true;
    }

    public InputObjectState read_committed(Uid uid, String typeName) throws ObjectStoreException {
        RecordInfo record = (RecordInfo)this.getContentForType(typeName).get(uid);
        if (record == null) {
            return null;
        }
        try {
            InputBuffer inputBuffer = new InputBuffer(record.data);
            UidHelper.unpackFrom(inputBuffer);
            inputBuffer.unpackString();
            return new InputObjectState(uid, typeName, inputBuffer.unpackBytes());
        }
        catch (Exception e) {
            throw new ObjectStoreException(e);
        }
    }

    public boolean contains(Uid uid, String typeName) {
        return this.getContentForType(typeName).containsKey(uid);
    }

    public String getStoreName() {
        return this.getClass().getSimpleName() + ":" + this.storeDirCanonicalPath;
    }

    public String[] getKnownTypes() {
        return this.content.keySet().toArray(new String[this.content.size()]);
    }

    public Uid[] getUidsForType(String typeName) {
        Set keySet = this.getContentForType(typeName).keySet();
        return keySet.toArray(new Uid[keySet.size()]);
    }

    private ConcurrentMap<Uid, RecordInfo> getContentForType(String typeName) {
        ConcurrentHashMap newMap;
        ConcurrentHashMap result = (ConcurrentHashMap)this.content.get(typeName);
        if (result == null && (result = (ConcurrentMap)this.content.putIfAbsent(typeName, newMap = new ConcurrentHashMap())) == null) {
            result = newMap;
        }
        return result;
    }

    private long getId(Uid uid, String typeName) {
        RecordInfo record = (RecordInfo)this.getContentForType(typeName).get(uid);
        if (record != null) {
            return record.id;
        }
        return this.maxID.incrementAndGet();
    }
}

