/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.handlers;

import io.undertow.UndertowOptions;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.proxy.LoadBalancingProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PersistentResourceDefinition;
import org.jboss.as.controller.ServiceRemoveStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.deployment.GlobalRequestControllerHandler;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Xnio;
import org.xnio.ssl.XnioSsl;

public class ReverseProxyHandlerHost
extends PersistentResourceDefinition {
    private static final RuntimeCapability<Void> REVERSE_PROXY_HOST_RUNTIME_CAPABILITY;
    public static final SimpleAttributeDefinition OUTBOUND_SOCKET_BINDING;
    public static final AttributeDefinition SCHEME;
    public static final AttributeDefinition PATH;
    public static final AttributeDefinition INSTANCE_ID;
    public static final SimpleAttributeDefinition SSL_CONTEXT;
    public static final SimpleAttributeDefinition SECURITY_REALM;
    public static final SimpleAttributeDefinition ENABLE_HTTP2;
    public static final ReverseProxyHandlerHost INSTANCE;

    private ReverseProxyHandlerHost() {
        super(new PersistentResourceDefinition.Parameters(PathElement.pathElement((String)"host"), (ResourceDescriptionResolver)UndertowExtension.getResolver("handler", "reverse-proxy", "host")).setCapabilities(new RuntimeCapability[]{REVERSE_PROXY_HOST_RUNTIME_CAPABILITY}));
    }

    public Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(OUTBOUND_SOCKET_BINDING, SCHEME, INSTANCE_ID, PATH, SSL_CONTEXT, SECURITY_REALM, ENABLE_HTTP2);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        ReverseProxyHostAdd add = new ReverseProxyHostAdd();
        this.registerAddOperation(resourceRegistration, add, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
        this.registerRemoveOperation(resourceRegistration, (AbstractRemoveStepHandler)new ServiceRemoveStepHandler(add){

            protected ServiceName serviceName(String name, PathAddress address) {
                return REVERSE_PROXY_HOST_RUNTIME_CAPABILITY.getCapabilityServiceName(address);
            }
        }, new OperationEntry.Flag[]{OperationEntry.Flag.RESTART_RESOURCE_SERVICES});
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final class ReverseProxyHostService
    implements Service<ReverseProxyHostService> {
        private final InjectedValue<HttpHandler> proxyHandler = new InjectedValue();
        private final InjectedValue<OutboundSocketBinding> socketBinding = new InjectedValue();
        private final InjectedValue<SecurityRealm> securityRealm = new InjectedValue();
        private final InjectedValue<SSLContext> sslContext = new InjectedValue();
        private final String instanceId;
        private final String scheme;
        private final String path;
        private final boolean enableHttp2;

        private ReverseProxyHostService(String scheme, String instanceId, String path, boolean enableHttp2) {
            this.instanceId = instanceId;
            this.scheme = scheme;
            this.path = path;
            this.enableHttp2 = enableHttp2;
        }

        private URI getUri() throws URISyntaxException {
            OutboundSocketBinding binding = (OutboundSocketBinding)this.socketBinding.getValue();
            return new URI(this.scheme, null, binding.getUnresolvedDestinationAddress(), binding.getDestinationPort(), this.path, null, null);
        }

        public void start(StartContext startContext) throws StartException {
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.getValue() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.getValue()).getNext() : (HttpHandler)this.proxyHandler.getValue());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                SecurityRealm securityRealm;
                SSLContext sslContext = (SSLContext)this.sslContext.getOptionalValue();
                if (sslContext == null && (securityRealm = (SecurityRealm)this.securityRealm.getOptionalValue()) != null) {
                    sslContext = securityRealm.getSSLContext();
                }
                if (sslContext == null) {
                    client.addHost(this.getUri(), this.instanceId, null, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)this.enableHttp2));
                } else {
                    OptionMap.Builder builder = OptionMap.builder();
                    builder.set(Options.USE_DIRECT_BUFFERS, true);
                    OptionMap combined = builder.getMap();
                    UndertowXnioSsl xnioSsl = new UndertowXnioSsl(Xnio.getInstance(), combined, sslContext);
                    client.addHost(this.getUri(), this.instanceId, (XnioSsl)xnioSsl, OptionMap.create((Option)UndertowOptions.ENABLE_HTTP2, (Object)this.enableHttp2));
                }
            }
            catch (URISyntaxException e) {
                throw new StartException((Throwable)e);
            }
        }

        public void stop(StopContext stopContext) {
            ProxyHandler proxyHandler = (ProxyHandler)(this.proxyHandler.getValue() instanceof GlobalRequestControllerHandler ? ((GlobalRequestControllerHandler)this.proxyHandler.getValue()).getNext() : (HttpHandler)this.proxyHandler.getValue());
            LoadBalancingProxyClient client = (LoadBalancingProxyClient)proxyHandler.getProxyClient();
            try {
                client.removeHost(this.getUri());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public ReverseProxyHostService getValue() throws IllegalStateException, IllegalArgumentException {
            return this;
        }
    }

    private final class ReverseProxyHostAdd
    extends AbstractAddStepHandler {
        public ReverseProxyHostAdd() {
            super(ReverseProxyHandlerHost.this.getAttributes());
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            PathAddress address = context.getCurrentAddress();
            String proxyName = address.getElement(address.size() - 2).getValue();
            String socketBinding = OUTBOUND_SOCKET_BINDING.resolveModelAttribute(context, model).asString();
            String scheme = SCHEME.resolveModelAttribute(context, model).asString();
            String path = PATH.resolveModelAttribute(context, model).asString();
            boolean enableHttp2 = ENABLE_HTTP2.resolveModelAttribute(context, model).asBoolean();
            ModelNode securityRealm = SECURITY_REALM.resolveModelAttribute(context, model);
            ModelNode sslContext = SSL_CONTEXT.resolveModelAttribute(context, model);
            String jvmRoute = model.hasDefined("instance-id") ? INSTANCE_ID.resolveModelAttribute(context, model).asString() : null;
            ReverseProxyHostService service = new ReverseProxyHostService(scheme, jvmRoute, path, enableHttp2);
            CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(REVERSE_PROXY_HOST_RUNTIME_CAPABILITY, (Service)service).addCapabilityRequirement("org.wildfly.extension.undertow.handler", HttpHandler.class, (Injector)service.proxyHandler, new String[]{proxyName}).addCapabilityRequirement("org.wildfly.network.outbound-socket-binding", OutboundSocketBinding.class, (Injector)service.socketBinding, new String[]{socketBinding});
            if (sslContext.isDefined()) {
                builder.addCapabilityRequirement("org.wildfly.security.ssl-context", SSLContext.class, (Injector)service.sslContext, new String[]{sslContext.asString()});
            }
            if (securityRealm.isDefined()) {
                SecurityRealm.ServiceUtil.addDependency((ServiceBuilder)builder, (Injector)service.securityRealm, (String)securityRealm.asString());
            }
            builder.install();
        }
    }
}

