/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.naming;

import java.net.URI;
import java.security.Principal;
import javax.naming.NamingException;
import org.wildfly.naming.client.NamingProvider;
import org.wildfly.naming.client.ProviderEnvironment;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.PeerIdentity;
import org.wildfly.security.auth.client.PeerIdentityContext;

public class HttpNamingProvider
implements NamingProvider {
    public static final Principal FAKE_PRINCIPAL = new Principal(){

        @Override
        public String getName() {
            return "";
        }
    };
    private final ProviderEnvironment providerEnvironment;

    HttpNamingProvider(ProviderEnvironment providerEnvironment) {
        this.providerEnvironment = providerEnvironment;
    }

    @Override
    public ProviderEnvironment getProviderEnvironment() {
        return this.providerEnvironment;
    }

    @Override
    public PeerIdentity getPeerIdentityForNaming(URI location) throws NamingException {
        return new HttpPeerIdentityContext(location).authenticate(null);
    }

    static class HttpPeerIdentityContext
    extends PeerIdentityContext {
        private final URI uri;

        HttpPeerIdentityContext(URI uri) {
            this.uri = uri;
        }

        @Override
        public HttpPeerIdentity authenticate(AuthenticationConfiguration authenticationConfiguration) {
            return this.constructIdentity(configuration -> new HttpPeerIdentity((PeerIdentity.Configuration)configuration, this.uri));
        }
    }

    static class HttpPeerIdentity
    extends PeerIdentity {
        private final URI uri;

        protected HttpPeerIdentity(PeerIdentity.Configuration configuration, URI uri) {
            super(configuration, FAKE_PRINCIPAL);
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

