/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import org.jboss.as.repository.PathUtil;

public interface ContentFilter {
    public boolean acceptFile(Path var1, Path var2) throws IOException;

    public boolean acceptFile(Path var1, Path var2, InputStream var3) throws IOException;

    public boolean acceptDirectory(Path var1, Path var2) throws IOException;

    public static class Factory {
        public static ContentFilter createFileFilter(int depth, boolean archiveOnly) {
            return new FileContentFilter(depth, archiveOnly);
        }

        public static ContentFilter createContentFilter(int depth, boolean archiveOnly) {
            return new SimpleContentFilter(depth, archiveOnly);
        }
    }

    public static class FileContentFilter
    extends SimpleContentFilter {
        private FileContentFilter(int depth, boolean archiveOnly) {
            super(depth, archiveOnly);
        }

        @Override
        public boolean acceptDirectory(Path rootPath, Path dir) {
            return false;
        }
    }

    public static class SimpleContentFilter
    implements ContentFilter {
        private final int depth;
        private final boolean archiveOnly;

        private SimpleContentFilter(int depth, boolean archiveOnly) {
            this.depth = depth;
            this.archiveOnly = archiveOnly;
        }

        @Override
        public boolean acceptFile(Path rootPath, Path file) throws IOException {
            return this.acceptFile(rootPath, file, null);
        }

        @Override
        public boolean acceptFile(Path rootPath, Path file, InputStream in) throws IOException {
            Path relativePath = rootPath.relativize(file);
            if (this.depth < 0 || this.depth >= relativePath.getNameCount()) {
                if (this.archiveOnly) {
                    if (in != null) {
                        return PathUtil.isArchive(in);
                    }
                    return PathUtil.isArchive(file);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean acceptDirectory(Path rootPath, Path dir) {
            Path relativePath = rootPath.relativize(dir);
            if (!this.archiveOnly) {
                return this.depth < 0 || this.depth >= relativePath.getNameCount();
            }
            return false;
        }
    }
}

