/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.security.Attribute;
import org.jboss.as.security.Element;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.as.security.elytron.ElytronIntegrationResourceDefinitions;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class SecuritySubsystemParser_2_0
extends SecuritySubsystemParser {
    protected SecuritySubsystemParser_2_0() {
    }

    @Override
    protected void readElement(XMLExtendedStreamReader reader, Element element, List<ModelNode> operations, PathAddress subsystemPath, ModelNode subsystemNode) throws XMLStreamException {
        switch (element) {
            case ELYTRON_INTEGRATION: {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                block7: while (reader.hasNext() && reader.nextTag() != 2) {
                    Element innerElement = Element.forName(reader.getLocalName());
                    switch (innerElement) {
                        case SECURITY_REALMS: {
                            this.parseSecurityRealms(reader, operations, subsystemPath);
                            continue block7;
                        }
                        case TLS: {
                            this.parseTLS(reader, operations, subsystemPath);
                            continue block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                break;
            }
            default: {
                super.readElement(reader, element, operations, subsystemPath, subsystemNode);
            }
        }
    }

    protected void parseSecurityRealms(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPath) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ELYTRON_REALM: {
                    this.parseElytronRealm(reader, operations, subsystemPath);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseElytronRealm(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPath) throws XMLStreamException {
        ModelNode elytronRealmAddOperation = Util.createAddOperation();
        PathElement elytronRealmPath = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.LEGACY_JAAS_CONFIG);
        int count = reader.getAttributeCount();
        block5: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null || value.length() == 0) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    elytronRealmPath = PathElement.pathElement((String)"elytron-realm", (String)value);
                    continue block5;
                }
                case LEGACY_JAAS_CONFIG: {
                    ElytronIntegrationResourceDefinitions.LEGACY_JAAS_CONFIG.parseAndSetParameter(value, elytronRealmAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                case APPLY_ROLE_MAPPERS: {
                    ElytronIntegrationResourceDefinitions.APPLY_ROLE_MAPPERS.parseAndSetParameter(value, elytronRealmAddOperation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        elytronRealmAddOperation.get("address").set(subsystemPath.append(new PathElement[]{elytronRealmPath}).toModelNode());
        operations.add(elytronRealmAddOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    protected void parseTLS(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPath) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ELYTRON_KEY_STORE: {
                    this.parseTLSEntity(reader, operations, subsystemPath, "elytron-key-store");
                    continue block6;
                }
                case ELYTRON_TRUST_STORE: {
                    this.parseTLSEntity(reader, operations, subsystemPath, "elytron-trust-store");
                    continue block6;
                }
                case ELYTRON_KEY_MANAGER: {
                    this.parseTLSEntity(reader, operations, subsystemPath, "elytron-key-manager");
                    continue block6;
                }
                case ELYTRON_TRUST_MANAGER: {
                    this.parseTLSEntity(reader, operations, subsystemPath, "elytron-trust-manager");
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void parseTLSEntity(XMLExtendedStreamReader reader, List<ModelNode> operations, PathAddress subsystemPath, String tlsEntityName) throws XMLStreamException {
        ModelNode elytronTLSEntityAddOperation = Util.createAddOperation();
        PathElement elytronTLSEntityPath = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.LEGACY_JSSE_CONFIG);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    if (value == null || value.length() == 0) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                    elytronTLSEntityPath = PathElement.pathElement((String)tlsEntityName, (String)value);
                    continue block4;
                }
                case LEGACY_JSSE_CONFIG: {
                    ElytronIntegrationResourceDefinitions.LEGACY_JSSE_CONFIG.parseAndSetParameter(value, elytronTLSEntityAddOperation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (required.size() > 0) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        elytronTLSEntityAddOperation.get("address").set(subsystemPath.append(new PathElement[]{elytronTLSEntityPath}).toModelNode());
        operations.add(elytronTLSEntityAddOperation);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }
}

