/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery.impl;

import org.wildfly.common.Assert;
import org.wildfly.discovery.ServiceRegistration;
import org.wildfly.discovery.ServiceURL;
import org.wildfly.discovery.spi.RegistryProvider;

public final class AggregateRegistryProvider
implements RegistryProvider {
    private final RegistryProvider[] delegates;

    public AggregateRegistryProvider(RegistryProvider[] delegates) {
        Assert.checkNotNullParam((String)"delegates", (Object)delegates);
        this.delegates = delegates;
    }

    @Override
    public ServiceRegistration registerService(ServiceURL serviceURL) {
        Assert.checkNotNullParam((String)"serviceURL", (Object)serviceURL);
        ServiceRegistration[] array = new ServiceRegistration[this.delegates.length];
        RegistryProvider[] delegates = this.delegates;
        int delegatesLength = delegates.length;
        for (int i = 0; i < delegatesLength; ++i) {
            array[i] = delegates[i].registerService(serviceURL);
        }
        return ServiceRegistration.aggregate(array);
    }

    @Override
    public ServiceRegistration registerServices(ServiceURL ... serviceURLs) {
        Assert.checkNotNullParam((String)"serviceURLs", (Object)serviceURLs);
        ServiceRegistration[] array = new ServiceRegistration[this.delegates.length];
        RegistryProvider[] delegates = this.delegates;
        int delegatesLength = delegates.length;
        for (int i = 0; i < delegatesLength; ++i) {
            array[i] = delegates[i].registerServices(serviceURLs);
        }
        return ServiceRegistration.aggregate(array);
    }
}

