/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.support.finder;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.combine.CombiningAlgFactory;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyCollection;
import org.jboss.security.xacml.sunxacml.support.finder.PolicyReader;
import org.jboss.security.xacml.sunxacml.support.finder.TopLevelPolicyException;

public class StaticPolicyFinderModule
extends PolicyFinderModule {
    private List policyList;
    private PolicyCollection policies;
    private File schemaFile = null;
    private static final String POLICY_ID = "urn:com:sun:xacml:support:finder:dynamic-policy-set";
    private static URI policyId;
    private static final Logger logger;

    public StaticPolicyFinderModule(List policyList) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticPolicyFinderModule(List policyList, String schemaFile) {
        this.policyList = policyList;
        this.policies = new PolicyCollection();
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public StaticPolicyFinderModule(String combiningAlg, List policyList) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        String schemaName = System.getProperty("com.sun.xacml.PolicySchema");
        if (schemaName != null) {
            this.schemaFile = new File(schemaName);
        }
    }

    public StaticPolicyFinderModule(String combiningAlg, List policyList, String schemaFile) throws URISyntaxException, UnknownIdentifierException {
        PolicyCombiningAlgorithm alg = (PolicyCombiningAlgorithm)CombiningAlgFactory.getInstance().createAlgorithm(new URI(combiningAlg));
        this.policyList = policyList;
        this.policies = new PolicyCollection(alg, policyId);
        if (schemaFile != null) {
            this.schemaFile = new File(schemaFile);
        }
    }

    public boolean isRequestSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
        PolicyReader reader = new PolicyReader(finder, logger, this.schemaFile);
        for (String str : this.policyList) {
            AbstractPolicy policy = null;
            try {
                try {
                    URL url = new URL(str);
                    policy = reader.readPolicy(url);
                }
                catch (MalformedURLException murle) {
                    policy = reader.readPolicy(new File(str));
                }
                if (this.policies.addPolicy(policy) || !logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "tried to load the same policy multiple times: " + str);
            }
            catch (ParsingException pe) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Error reading policy: " + str, pe);
            }
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        try {
            AbstractPolicy policy = this.policies.getPolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (TopLevelPolicyException tlpe) {
            return new PolicyFinderResult(tlpe.getStatus());
        }
    }

    static {
        block2: {
            policyId = null;
            logger = Logger.getLogger(StaticPolicyFinderModule.class.getName());
            try {
                policyId = new URI(POLICY_ID);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, "couldn't assign default policy id");
            }
        }
    }
}

