/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.auth.server.FlexibleIdentityAssociation;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

public class SecurityContextImpl
extends AbstractSecurityContext {
    private static final Logger log = Logger.getLogger((String)"org.wildfly.security.http");
    private final ElytronHttpExchange httpExchange;
    private final SecurityDomain securityDomain;
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final String programmaticMechanismName;
    private final FlexibleIdentityAssociation flexibleIdentityAssociation;
    private HttpAuthenticator httpAuthenticator;
    private Runnable logoutHandler;

    private SecurityContextImpl(Builder builder) {
        super((HttpServerExchange)Assert.checkNotNullParam((String)"exchange", (Object)builder.exchange));
        this.httpExchange = (ElytronHttpExchange)Assert.checkNotNullParam((String)"httpExchange", (Object)builder.httpExchange);
        this.securityDomain = builder.securityDomain;
        this.mechanismSupplier = builder.mechanismSupplier;
        this.programmaticMechanismName = builder.programmaticMechanismName;
        this.flexibleIdentityAssociation = this.securityDomain != null ? this.securityDomain.getAnonymousSecurityIdentity().createFlexibleAssociation() : null;
    }

    public boolean authenticate() {
        if (this.isAuthenticated()) {
            return true;
        }
        this.httpAuthenticator = HttpAuthenticator.builder().setMechanismSupplier((Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", this.mechanismSupplier)).setProgrammaticMechanismName((String)Assert.checkNotNullParam((String)"programmaticMechanismName", (Object)this.programmaticMechanismName)).setSecurityDomain(this.securityDomain).setHttpExchangeSpi((HttpExchangeSpi)this.httpExchange).setRequired(this.isAuthenticationRequired()).setIgnoreOptionalFailures(false).registerLogoutHandler(this::setLogoutHandler).build();
        try {
            return this.httpAuthenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            log.trace((Object)"Authentication failed.", (Throwable)e);
            this.exchange.setStatusCode(500);
            return false;
        }
    }

    private void setLogoutHandler(Runnable runnable) {
        this.logoutHandler = runnable;
    }

    public boolean login(String username, String password) {
        if (this.httpAuthenticator == null) {
            log.trace((Object)"No HttpAuthenticator available for authentication.");
            return false;
        }
        SecurityIdentity securityIdentity = this.httpAuthenticator.login(username, password);
        if (securityIdentity != null) {
            this.flexibleIdentityAssociation.setIdentity(securityIdentity);
        }
        return securityIdentity != null;
    }

    public void logout() {
        super.logout();
        if (this.logoutHandler != null) {
            this.logoutHandler.run();
        }
        if (this.flexibleIdentityAssociation != null) {
            this.flexibleIdentityAssociation.setIdentity(this.securityDomain.getAnonymousSecurityIdentity());
        }
    }

    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
        throw new UnsupportedOperationException();
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        throw new UnsupportedOperationException();
    }

    public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }

    FlexibleIdentityAssociation getFlexibleIdentityAssociation() {
        return this.flexibleIdentityAssociation;
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder {
        HttpServerExchange exchange;
        String programmaticMechanismName;
        SecurityDomain securityDomain;
        Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
        ElytronHttpExchange httpExchange;

        private Builder() {
        }

        Builder setExchange(HttpServerExchange exchange) {
            this.exchange = exchange;
            return this;
        }

        @Deprecated
        Builder setProgramaticMechanismName(String programmaticMechanismName) {
            return this.setProgrammaticMechanismName(programmaticMechanismName);
        }

        Builder setProgrammaticMechanismName(String programmaticMechanismName) {
            this.programmaticMechanismName = programmaticMechanismName;
            return this;
        }

        Builder setSecurityDomain(SecurityDomain securityDomain) {
            this.securityDomain = securityDomain;
            return this;
        }

        Builder setMechanismSupplier(Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
            this.mechanismSupplier = mechanismSupplier;
            return this;
        }

        Builder setHttpExchangeSupplier(ElytronHttpExchange httpExchange) {
            this.httpExchange = httpExchange;
            return this;
        }

        SecurityContext build() {
            return new SecurityContextImpl(this);
        }
    }
}

