/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CustomStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class CustomStoreBuilder
extends StoreBuilder<CustomStoreConfiguration, CustomStoreConfigurationBuilder> {
    private final ValueDependency<Module> module;
    private volatile String className;

    CustomStoreBuilder(PathAddress address) {
        super(address, CustomStoreConfigurationBuilder.class);
        this.module = new InjectedValueDependency(CacheComponent.MODULE.getServiceName(address.getParent()), Module.class);
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.className = CustomStoreResourceDefinition.Attribute.CLASS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return this.module.register(super.build(target));
    }

    @Override
    public PersistenceConfiguration getValue() {
        PersistenceConfiguration persistence = super.getValue();
        StoreConfiguration store = (StoreConfiguration)persistence.stores().get(0);
        try {
            Class<StoreConfigurationBuilder> storeClass = ((Module)this.module.getValue()).getClassLoader().loadClass(this.className).asSubclass(StoreConfigurationBuilder.class);
            return ((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)((StoreConfigurationBuilder)new ConfigurationBuilder().persistence().passivation(persistence.passivation()).addStore(storeClass).async().read(store.async()).fetchPersistentState(store.fetchPersistentState())).preload(store.preload())).purgeOnStartup(store.purgeOnStartup())).shared(store.shared())).withProperties(store.properties())).persistence().create();
        }
        catch (ClassCastException | ClassNotFoundException e) {
            throw InfinispanLogger.ROOT_LOGGER.invalidCacheStore(e, this.className);
        }
    }

    @Override
    public void accept(CustomStoreConfigurationBuilder builder) {
    }
}

