/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfiguration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheBuilder;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class SharedStateCacheBuilder
extends ClusteredCacheBuilder {
    private final ValueDependency<PartitionHandlingConfiguration> partitionHandling;
    private final ValueDependency<StateTransferConfiguration> stateTransfer;
    private final ValueDependency<SitesConfiguration> backups;

    SharedStateCacheBuilder(PathAddress address, CacheMode mode) {
        super(address, mode);
        this.partitionHandling = new InjectedValueDependency(CacheComponent.PARTITION_HANDLING.getServiceName(address), PartitionHandlingConfiguration.class);
        this.stateTransfer = new InjectedValueDependency(CacheComponent.STATE_TRANSFER.getServiceName(address), StateTransferConfiguration.class);
        this.backups = new InjectedValueDependency(CacheComponent.BACKUPS.getServiceName(address), SitesConfiguration.class);
    }

    @Override
    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        ServiceBuilder<Configuration> builder = super.build(target);
        for (Dependency dependency : Arrays.asList(this.partitionHandling, this.stateTransfer, this.backups)) {
            dependency.register(builder);
        }
        return builder;
    }

    @Override
    public void accept(ConfigurationBuilder builder) {
        super.accept(builder);
        builder.clustering().partitionHandling().read((PartitionHandlingConfiguration)this.partitionHandling.getValue());
        builder.clustering().stateTransfer().read((StateTransferConfiguration)this.stateTransfer.getValue());
        SitesConfigurationBuilder sitesBuilder = builder.sites();
        sitesBuilder.read((SitesConfiguration)this.backups.getValue());
    }
}

