/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.StoreBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.remote.HotRodStoreResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanRequirement;
import org.wildfly.clustering.infinispan.spi.RemoteCacheContainer;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class HotRodStoreBuilder
extends StoreBuilder<HotRodStoreConfiguration, HotRodStoreConfigurationBuilder> {
    private volatile ValueDependency<RemoteCacheContainer> remoteCacheContainer;
    private volatile String cacheConfiguration;

    HotRodStoreBuilder(PathAddress address) {
        super(address, HotRodStoreConfigurationBuilder.class);
    }

    @Override
    public Builder<PersistenceConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.cacheConfiguration = HotRodStoreResourceDefinition.Attribute.CACHE_CONFIGURATION.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        String remoteCacheContainerName = HotRodStoreResourceDefinition.Attribute.REMOTE_CACHE_CONTAINER.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.remoteCacheContainer = new InjectedValueDependency(InfinispanRequirement.REMOTE_CONTAINER.getServiceName(context, remoteCacheContainerName), RemoteCacheContainer.class);
        return super.configure(context, model);
    }

    @Override
    public ServiceBuilder<PersistenceConfiguration> build(ServiceTarget target) {
        return this.remoteCacheContainer.register(super.build(target));
    }

    @Override
    public void accept(HotRodStoreConfigurationBuilder builder) {
        builder.cacheConfiguration(this.cacheConfiguration).remoteCacheContainer((RemoteCacheContainer)this.remoteCacheContainer.getValue());
    }
}

