/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.clustering.controller.RuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ChannelRuntimeResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolMetricsHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.ModuleLoadException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;

public class ForkProtocolRuntimeResourceRegistration
implements RuntimeResourceRegistration,
ProtocolMetricsHandler.ProtocolLocator {
    @Override
    public Protocol findProtocol(OperationContext context) throws ClassNotFoundException, ModuleLoadException {
        ChannelFactory factory;
        FORK fork;
        JChannel channel;
        PathAddress address = context.getCurrentAddress();
        String channelName = address.getElement(address.size() - 3).getValue();
        String forkName = address.getElement(address.size() - 2).getValue();
        String protocolName = address.getElement(address.size() - 1).getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceController controller = registry.getService(JGroupsRequirement.CHANNEL.getServiceName(context, channelName));
        if (controller != null && (channel = (JChannel)controller.getValue()) != null && (fork = (FORK)channel.getProtocolStack().findProtocol(FORK.class)) != null && (controller = registry.getService(JGroupsRequirement.CHANNEL_FACTORY.getServiceName(context, channelName))) != null && (factory = (ChannelFactory)controller.getValue()) != null) {
            ProtocolStackConfiguration configuration = factory.getProtocolStackConfiguration();
            TransportConfiguration transport = configuration.getTransport();
            if (transport.getName().equals(protocolName)) {
                Class<?> protocolClass = ((TP)transport.createProtocol(configuration)).getClass();
                return channel.getProtocolStack().findProtocol(protocolClass);
            }
            for (ProtocolConfiguration protocol : configuration.getProtocols()) {
                if (!protocol.getName().equals(protocolName)) continue;
                Class<?> protocolClass = protocol.createProtocol(configuration).getClass();
                return fork.get(forkName).getProtocolStack().findProtocol(protocolClass);
            }
        }
        return null;
    }

    public void register(OperationContext context) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        String protocolName = context.getCurrentAddressValue();
        String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, resource.getModel()).asString();
        Class<? extends Protocol> protocolClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, protocolName, moduleName);
        final Map<String, ProtocolMetricsHandler.Attribute> attributes = ProtocolMetricsHandler.findProtocolAttributes(protocolClass);
        if (registration.getPathAddress().getLastElement().isWildcard()) {
            OverrideDescriptionProvider provider = new OverrideDescriptionProvider(){

                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                    HashMap<String, ModelNode> result = new HashMap<String, ModelNode>();
                    for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
                        ModelNode value = new ModelNode();
                        value.get("description").set(attribute.getDescription());
                        result.put(attribute.getName(), value);
                    }
                    return result;
                }

                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                    return Collections.emptyMap();
                }
            };
            registration = registration.registerOverrideModel(protocolName, provider);
        }
        ProtocolMetricsHandler handler = new ProtocolMetricsHandler(this);
        for (ProtocolMetricsHandler.Attribute attribute : attributes.values()) {
            String name = attribute.getName();
            ProtocolMetricsHandler.FieldType type = ProtocolMetricsHandler.FieldType.valueOf(attribute.getType());
            registration.registerMetric((AttributeDefinition)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type.getModelType()).setStorageRuntime()).build(), (OperationStepHandler)handler);
        }
    }

    public void unregister(OperationContext context) throws OperationFailedException {
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ManagementResourceRegistration registration = context.getResourceRegistrationForUpdate();
        String protocolName = context.getCurrentAddressValue();
        String moduleName = AbstractProtocolResourceDefinition.Attribute.MODULE.resolveModelAttribute((ExpressionResolver)context, resource.getModel()).asString();
        Class<? extends Protocol> protocolClass = ChannelRuntimeResourceRegistration.findProtocolClass(context, protocolName, moduleName);
        for (String attribute : ProtocolMetricsHandler.findProtocolAttributes(protocolClass).keySet()) {
            registration.unregisterAttribute(attribute);
        }
    }
}

