/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi.marshal.strategy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.rmi.PortableRemoteObject;
import org.jboss.javax.rmi.RemoteObjectSubstitutionManager;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStream;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStreamReader;
import org.wildfly.iiop.openjdk.rmi.marshal.CDRStreamWriter;
import org.wildfly.security.manager.WildFlySecurityManager;

public class StubStrategy {
    private CDRStreamWriter[] paramWriters;
    private List<Class<?>> exceptionList;
    private Map<String, ExceptionReader> exceptionMap;
    private CDRStreamReader retvalReader;
    private Class<?> retvalRemoteInterface;

    public static StubStrategy forMethod(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl) {
        return new StubStrategy(paramTypes, excepIds, excepTypes, retvalType, cl);
    }

    private StubStrategy(String[] paramTypes, String[] excepIds, String[] excepTypes, String retvalType, ClassLoader cl) {
        int i;
        if (cl == null) {
            cl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        }
        int len = paramTypes.length;
        this.paramWriters = new CDRStreamWriter[len];
        for (i = 0; i < len; ++i) {
            this.paramWriters[i] = CDRStream.writerFor(paramTypes[i], cl);
        }
        this.exceptionList = new ArrayList();
        this.exceptionMap = new HashMap<String, ExceptionReader>();
        len = excepIds.length;
        for (i = 0; i < len; ++i) {
            try {
                Class<?> clz = cl.loadClass(excepTypes[i]);
                this.exceptionList.add(clz);
                ExceptionReader exceptionReader = new ExceptionReader(clz, excepIds[i]);
                this.exceptionMap.put(exceptionReader.getReposId(), exceptionReader);
                continue;
            }
            catch (ClassNotFoundException e) {
                throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(excepTypes[i], e);
            }
        }
        this.retvalReader = CDRStream.readerFor(retvalType, cl);
        if (retvalType.charAt(0) == 'R') {
            try {
                this.retvalRemoteInterface = cl.loadClass(retvalType.substring(1));
            }
            catch (ClassNotFoundException e) {
                throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(retvalType.substring(1), e);
            }
        }
    }

    public void writeParams(OutputStream out, Object[] params) {
        int len = params.length;
        if (len != this.paramWriters.length) {
            throw IIOPLogger.ROOT_LOGGER.errorMashalingParams();
        }
        for (int i = 0; i < len; ++i) {
            Object param = params[i];
            if (param instanceof PortableRemoteObject) {
                try {
                    param = PortableRemoteObject.toStub((Remote)((Remote)param));
                }
                catch (NoSuchObjectException e) {
                    throw new RuntimeException(e);
                }
            }
            this.paramWriters[i].write(out, RemoteObjectSubstitutionManager.writeReplaceRemote((Object)param));
        }
    }

    public boolean isNonVoid() {
        return this.retvalReader != null;
    }

    public Object readRetval(InputStream in) {
        return this.retvalReader.read(in);
    }

    public Exception readException(String id, InputStream in) {
        ExceptionReader exceptionReader = this.exceptionMap.get(id);
        if (exceptionReader == null) {
            return new UnexpectedException(id);
        }
        return exceptionReader.read(in);
    }

    public boolean isDeclaredException(Throwable t) {
        Iterator<Class<?>> iterator = this.exceptionList.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public Object convertLocalRetval(Object obj) {
        if (this.retvalRemoteInterface == null) {
            return obj;
        }
        return PortableRemoteObject.narrow((Object)obj, this.retvalRemoteInterface);
    }

    private static class ExceptionReader {
        private Class<?> clz;
        private String reposId;
        private Method readMethod = null;

        ExceptionReader(Class<?> clz, String reposId) {
            this.clz = clz;
            if (IDLEntity.class.isAssignableFrom(clz) && UserException.class.isAssignableFrom(clz)) {
                String helperClassName = clz.getName() + "Helper";
                try {
                    Class<?> helperClass = clz.getClassLoader().loadClass(helperClassName);
                    Class[] paramTypes = new Class[]{org.omg.CORBA.portable.InputStream.class};
                    this.readMethod = helperClass.getMethod("read", paramTypes);
                    Method idMethod = helperClass.getMethod("id", null);
                    this.reposId = (String)idMethod.invoke(null, (Object[])null);
                }
                catch (ClassNotFoundException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorLoadingClass(helperClassName, e);
                }
                catch (NoSuchMethodException e) {
                    throw IIOPLogger.ROOT_LOGGER.noReadMethodInHelper(helperClassName, e);
                }
                catch (IllegalAccessException e) {
                    throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
                }
                catch (InvocationTargetException e) {
                    throw IIOPLogger.ROOT_LOGGER.unexpectedException(e.getTargetException());
                }
            } else {
                this.reposId = reposId;
            }
        }

        public String getReposId() {
            return this.reposId;
        }

        public Exception read(InputStream in) {
            if (this.readMethod != null) {
                try {
                    return (Exception)this.readMethod.invoke(null, in);
                }
                catch (IllegalAccessException e) {
                    throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
                }
                catch (InvocationTargetException e) {
                    throw IIOPLogger.ROOT_LOGGER.errorUnmarshaling(IDLEntity.class, e.getTargetException());
                }
            }
            in.read_string();
            return (Exception)in.read_value(this.clz);
        }
    }
}

